/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Utils;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import com.esaulpaugh.headlong.util.SuperSerial;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.function.IntConsumer;

public final class ArrayType<E extends ABIType<?>, J>
extends ABIType<J> {
    private static final ClassLoader CLASS_LOADER = ArrayType.class.getClassLoader();
    static final Class<String> STRING_CLASS = String.class;
    static final Class<String[]> STRING_ARRAY_CLASS = String[].class;
    private static final int ARRAY_LENGTH_BYTES = 32;
    static final int DYNAMIC_LENGTH = -1;
    private final boolean isString;
    final E elementType;
    private final int length;
    private final Class<?> arrayClass;

    ArrayType(String canonicalType, Class<J> clazz, E elementType, int length) {
        this(canonicalType, clazz, elementType, length, null);
    }

    ArrayType(String canonicalType, Class<J> clazz, E elementType, int length, Class<?> arrayClass) {
        super(canonicalType, clazz, ((ABIType)elementType).dynamic || length == -1);
        this.isString = clazz == STRING_CLASS;
        this.elementType = elementType;
        this.length = length;
        this.arrayClass = arrayClass;
    }

    public E getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isString() {
        return this.isString;
    }

    @Override
    Class<?> arrayClass() throws ClassNotFoundException {
        return this.arrayClass != null ? this.arrayClass : Class.forName('[' + this.clazz.getName(), false, CLASS_LOADER);
    }

    @Override
    public int typeCode() {
        return 6;
    }

    @Override
    int byteLength(Object value) {
        return this.totalLength(this.calcElementsLen(value));
    }

    private int calcElementsLen(Object value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length * 32;
            }
            case 1: {
                return Integers.roundLengthUp(this.byteCount(value), 32);
            }
            case 2: {
                return ((int[])value).length * 32;
            }
            case 3: {
                return ((long[])value).length * 32;
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * 32;
            }
            case 6: 
            case 7: {
                return this.measureByteLen((Object[])value);
            }
        }
        throw new Error();
    }

    private int staticByteLengthPacked() {
        if (this.length != -1) {
            return this.length * ((ABIType)this.elementType).byteLengthPacked(null);
        }
        throw new IllegalArgumentException("array of dynamic elements");
    }

    @Override
    int byteLengthPacked(Object value) {
        if (value == null) {
            return this.staticByteLengthPacked();
        }
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length;
            }
            case 1: {
                return this.byteCount(value);
            }
            case 2: {
                return ((int[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 3: {
                return ((long[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 6: 
            case 7: {
                return this.measurePackedByteLen((Object[])value);
            }
        }
        throw new Error();
    }

    private int byteCount(Object value) {
        return this.decodeIfString(value).length;
    }

    byte[] decodeIfString(Object value) {
        return !this.isString ? (byte[])value : Strings.decode((String)value, 1);
    }

    Object encodeIfString(byte[] bytes) {
        return !this.isString ? bytes : (byte[])Strings.encode(bytes, 1);
    }

    @Override
    public int validate(Object val) {
        this.validateClass(val);
        return this.totalLength(this.validateElements(val));
    }

    private int totalLength(int elementsLen) {
        return this.length != -1 ? elementsLen : 32 + elementsLen;
    }

    private int validateElements(Object val) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return this.validateBooleans((boolean[])val);
            }
            case 1: {
                return this.validateBytes(val);
            }
            case 2: {
                return this.validateInts((int[])val, (IntType)this.elementType);
            }
            case 3: {
                return this.validateLongs((long[])val, (LongType)this.elementType);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.validateObjects((Object[])val);
            }
        }
        throw new Error();
    }

    private int validateBooleans(boolean[] arr) {
        return this.checkLength(arr.length, arr) * 32;
    }

    private int validateBytes(Object arr) {
        return Integers.roundLengthUp(this.checkLength(this.byteCount(arr), arr), 32);
    }

    private int validateInts(int[] arr, IntType type) {
        return this.validateUnits(arr.length, arr, i -> type.validatePrimitive(arr[i]));
    }

    private int validateLongs(long[] arr, LongType type) {
        return this.validateUnits(arr.length, arr, i -> type.validatePrimitive(arr[i]));
    }

    private int validateUnits(int len, Object arr, IntConsumer elementValidator) {
        int i;
        this.checkLength(len, arr);
        try {
            for (i = 0; i < len; ++i) {
                elementValidator.accept(i);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("array index " + i + ": " + iae.getMessage());
        }
        return len * 32;
    }

    private int validateObjects(Object[] elements) {
        this.checkLength(elements.length, elements);
        return this.measureObjects(elements, i -> ((ABIType)this.elementType).validate(elements[i]));
    }

    private int measureByteLen(Object[] elements) {
        return this.measureObjects(elements, i -> ((ABIType)this.elementType).byteLength(elements[i]));
    }

    private int measurePackedByteLen(Object[] elements) {
        return this.measureObjects(elements, i -> ((ABIType)this.elementType).byteLengthPacked(elements[i]));
    }

    private int measureObjects(Object[] elements, Inspector inspector) {
        int byteLength = 0;
        for (int i = 0; i < elements.length; ++i) {
            byteLength += inspector.inspect(i);
        }
        return !((ABIType)this.elementType).dynamic ? byteLength : elements.length * 32 + byteLength;
    }

    private int checkLength(int valueLen, Object value) {
        if (this.length != valueLen && this.length != -1) {
            throw new IllegalArgumentException(Utils.friendlyClassName(value.getClass(), valueLen) + " not instanceof " + Utils.friendlyClassName(this.clazz, this.length) + ", " + valueLen + " != " + this.length);
        }
        return valueLen;
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        this.encodeArrayTail(value, dest);
    }

    private void insert(int len, ByteBuffer dest, Runnable insert) {
        if (this.length == -1) {
            Encoding.insertInt(len, dest);
        }
        insert.run();
    }

    private void encodeArrayTail(Object v, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                this.encodeBooleans((boolean[])v, dest);
                return;
            }
            case 1: {
                this.encodeBytes(this.decodeIfString(v), dest);
                return;
            }
            case 2: {
                this.encodeInts((int[])v, dest);
                return;
            }
            case 3: {
                this.encodeLongs((long[])v, dest);
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.encodeObjects((Object[])v, dest);
                return;
            }
        }
        throw new Error();
    }

    private void encodeBooleans(boolean[] arr, ByteBuffer dest) {
        this.insert(arr.length, dest, () -> {
            for (boolean e : arr) {
                BooleanType.encodeBoolean(e, dest);
            }
        });
    }

    private void encodeBytes(byte[] arr, ByteBuffer dest) {
        this.insert(arr.length, dest, () -> Encoding.insertBytesPadded(arr, dest));
    }

    private void encodeInts(int[] arr, ByteBuffer dest) {
        this.insert(arr.length, dest, () -> {
            for (int e : arr) {
                Encoding.insertInt(e, dest);
            }
        });
    }

    private void encodeLongs(long[] arr, ByteBuffer dest) {
        this.insert(arr.length, dest, () -> {
            for (long e : arr) {
                Encoding.insertInt(e, dest);
            }
        });
    }

    private void encodeObjects(Object[] arr, ByteBuffer dest) {
        if (this.dynamic) {
            this.insert(arr.length, dest, () -> this.insertOffsets(arr, dest));
        }
        for (Object object : arr) {
            ((ABIType)this.elementType).encodeTail(object, dest);
        }
    }

    private void insertOffsets(Object[] objects, ByteBuffer dest) {
        if (((ABIType)this.elementType).dynamic) {
            int nextOffset = objects.length * 32;
            for (Object object : objects) {
                nextOffset = Encoding.insertOffset(nextOffset, dest, ((ABIType)this.elementType).byteLength(object));
            }
        }
    }

    @Override
    J decode(ByteBuffer bb, byte[] unitBuffer) {
        int arrayLen = this.length == -1 ? Encoding.UINT17.decode(bb, unitBuffer) : this.length;
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return (J)ArrayType.decodeBooleans(bb, arrayLen, unitBuffer);
            }
            case 1: {
                return (J)this.decodeBytes(bb, arrayLen);
            }
            case 2: {
                return (J)ArrayType.decodeInts((IntType)this.elementType, bb, arrayLen, unitBuffer);
            }
            case 3: {
                return (J)ArrayType.decodeLongs((LongType)this.elementType, bb, arrayLen, unitBuffer);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (J)this.decodeObjects(arrayLen, bb, unitBuffer);
            }
        }
        throw new Error();
    }

    private static boolean[] decodeBooleans(ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        boolean[] booleans = new boolean[arrayLen];
        int booleanOffset = 31;
        for (int i = 0; i < arrayLen; ++i) {
            bb.get(unitBuffer);
            for (int j = 0; j < 31; ++j) {
                if (unitBuffer[j] == 0) continue;
                throw ArrayType.illegalBoolean(bb);
            }
            byte last = unitBuffer[31];
            if (last == 1) {
                booleans[i] = true;
                continue;
            }
            if (last == 0) continue;
            throw ArrayType.illegalBoolean(bb);
        }
        return booleans;
    }

    private static IllegalArgumentException illegalBoolean(ByteBuffer bb) {
        return new IllegalArgumentException("illegal boolean value @ " + (bb.position() - 32));
    }

    private Object decodeBytes(ByteBuffer bb, int arrayLen) {
        byte[] data = new byte[arrayLen];
        byte[] padding = new byte[Integers.roundLengthUp(arrayLen, 32) - arrayLen];
        bb.get(data);
        bb.get(padding);
        for (byte b : padding) {
            if (b == 0) continue;
            throw new IllegalArgumentException("malformed array: non-zero padding byte");
        }
        return this.encodeIfString(data);
    }

    private static int[] decodeInts(IntType intType, ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        int[] ints = new int[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            ints[i] = intType.decode(bb, unitBuffer);
        }
        return ints;
    }

    private static long[] decodeLongs(LongType longType, ByteBuffer bb, int arrayLen, byte[] unitBuffer) {
        long[] longs = new long[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            longs[i] = longType.decode(bb, unitBuffer);
        }
        return longs;
    }

    private Object[] decodeObjects(int len, ByteBuffer bb, byte[] unitBuffer) {
        Object[] elements = (Object[])Array.newInstance(((ABIType)this.elementType).clazz, len);
        if (!this.dynamic || !((ABIType)this.elementType).dynamic) {
            for (int i2 = 0; i2 < len; ++i2) {
                elements[i2] = ((ABIType)this.elementType).decode(bb, unitBuffer);
            }
        } else {
            int tailStart = bb.position();
            int[] offsets = new int[len];
            for (int i3 = 0; i3 < len; ++i3) {
                offsets[i3] = Encoding.UINT31.decode(bb, unitBuffer);
            }
            ArrayType.decodeTails(bb, offsets, tailStart, i -> {
                elements[i] = ((ABIType)this.elementType).decode(bb, unitBuffer);
            });
        }
        return elements;
    }

    @Override
    public J parseArgument(String s) {
        return (J)SuperSerial.deserializeArray(this, s, false, this.clazz);
    }

    @FunctionalInterface
    private static interface Inspector {
        public int inspect(int var1);
    }
}

