/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class BigIntegerType
extends UnitType<BigInteger> {
    BigIntegerType(String canonicalType, int bitLength, boolean unsigned) {
        super(canonicalType, BigInteger.class, bitLength, unsigned);
    }

    @Override
    Class<?> arrayClass() {
        return BigInteger[].class;
    }

    @Override
    public int typeCode() {
        return 4;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        this.validateBigInt((BigInteger)value);
        return 32;
    }

    @Override
    int encodeHead(Object value, ByteBuffer dest, int nextOffset) {
        Encoding.insertInt((BigInteger)value, 32, dest);
        return nextOffset;
    }

    @Override
    BigInteger decode(ByteBuffer bb, byte[] unitBuffer) {
        return this.decodeValid(bb, unitBuffer);
    }

    @Override
    public BigInteger parseArgument(String s) {
        BigInteger bigInt = new BigInteger(s);
        this.validate(bigInt);
        return bigInt;
    }
}

