/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.nio.ByteBuffer;

public final class ByteType
extends UnitType<Byte> {
    static final ByteType SIGNED = new ByteType("int8", false);

    private ByteType(String canonicalType, boolean unsigned) {
        super(canonicalType, Byte.class, 8, unsigned);
    }

    @Override
    Class<?> arrayClass() {
        return byte[].class;
    }

    @Override
    public int typeCode() {
        return 1;
    }

    @Override
    int byteLengthPacked(Object value) {
        return 1;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        return 32;
    }

    @Override
    Byte decode(ByteBuffer bb, byte[] unitBuffer) {
        return this.decodeValid(bb, unitBuffer).byteValue();
    }

    @Override
    public Byte parseArgument(String s) {
        Byte b = Byte.parseByte(s);
        this.validate(b);
        return b;
    }
}

