/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.Utils;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.esaulpaugh.headlong.util.Strings;
import com.google.gson.JsonObject;
import com.joemelsha.crypto.hash.Keccak;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Function
implements ABIObject {
    private static final Pattern ALL_ASCII_NO_OPEN_PAREN = Pattern.compile("^[[^(]&&\\p{ASCII}]*$");
    private static final Pattern OPEN_PAREN_OR_NON_ASCII = Pattern.compile("[([^\\p{ASCII}]]");
    public static final int SELECTOR_LEN = 4;
    private final Type type;
    private final String name;
    private final TupleType inputTypes;
    private final TupleType outputTypes;
    private final String stateMutability;
    private final byte[] selector = new byte[4];
    private final String hashAlgorithm;

    public Function(String signature) {
        this(signature, null);
    }

    public Function(String signature, String outputs) {
        this(Type.FUNCTION, signature, outputs, Function.newDefaultDigest());
    }

    public Function(String signature, String outputs, MessageDigest messageDigest) {
        this(Type.FUNCTION, signature, outputs, messageDigest);
    }

    public Function(Type type, String signature, String outputs, MessageDigest messageDigest) {
        this(type, (String)(type != Type.FUNCTION && type != Type.RECEIVE && signature.startsWith("(") ? null : signature.substring(0, signature.indexOf(40))), TupleType.parse(signature.substring(signature.indexOf(40))), outputs != null ? TupleType.parse(outputs) : TupleType.EMPTY, null, messageDigest);
    }

    public Function(Type type, String name, TupleType inputTypes, TupleType outputTypes, String stateMutability, MessageDigest messageDigest) {
        this.type = Objects.requireNonNull(type);
        this.name = name != null ? Utils.regexValidate(ALL_ASCII_NO_OPEN_PAREN, OPEN_PAREN_OR_NON_ASCII, name) : null;
        this.inputTypes = Objects.requireNonNull(inputTypes);
        this.outputTypes = Objects.requireNonNull(outputTypes);
        this.stateMutability = stateMutability;
        this.hashAlgorithm = messageDigest.getAlgorithm();
        this.validateFunction();
        this.generateSelector(messageDigest);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public TupleType getParamTypes() {
        return this.inputTypes;
    }

    public TupleType getOutputTypes() {
        return this.outputTypes;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public byte[] selector() {
        return Arrays.copyOf(this.selector, this.selector.length);
    }

    public String selectorHex() {
        return Strings.encode(this.selector);
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name != null ? this.name + this.inputTypes.canonicalType : this.inputTypes.canonicalType;
    }

    private void validateFunction() {
        switch (this.type.toString()) {
            case "function": {
                if (this.name != null) break;
                throw this.validationErr("define name");
            }
            case "receive": {
                if (!"receive".equals(this.name)) {
                    throw this.validationErr("define name as \"receive\"");
                }
                if (!"payable".equals(this.stateMutability)) {
                    throw this.validationErr("define stateMutability as \"payable\"");
                }
            }
            case "fallback": {
                if (this.inputTypes.elementTypes.length > 0) {
                    throw this.validationErr("define no inputs");
                }
            }
            case "constructor": {
                if (this.outputTypes.elementTypes.length > 0) {
                    throw this.validationErr("define no outputs");
                }
                if (this.type != Type.RECEIVE && this.name != null) {
                    throw this.validationErr("not define name");
                }
                return;
            }
            default: {
                throw new Error();
            }
        }
    }

    private IllegalArgumentException validationErr(String typeRuleStr) {
        return new IllegalArgumentException("type is \"" + (Object)((Object)this.type) + "\"; functions of this type must " + typeRuleStr);
    }

    private void generateSelector(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(Strings.decode(this.getCanonicalSignature(), 1));
        try {
            messageDigest.digest(this.selector, 0, 4);
        }
        catch (DigestException de) {
            throw new RuntimeException(de);
        }
    }

    public int measureCallLength(Tuple args) {
        return 4 + this.inputTypes.measureEncodedLength(args);
    }

    public ByteBuffer encodeCallWithArgs(Object ... args) {
        return this.encodeCall(new Tuple(args));
    }

    public ByteBuffer encodeCall(Tuple args) {
        ByteBuffer dest = ByteBuffer.wrap(new byte[this.measureCallLength(args)]);
        this.encodeCall(args, dest);
        return dest;
    }

    public Function encodeCall(Tuple args, ByteBuffer dest) {
        this.inputTypes.validate(args);
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
        return this;
    }

    public Tuple decodeCall(byte[] array) {
        return this.decodeCall(ByteBuffer.wrap(array));
    }

    public Tuple decodeCall(ByteBuffer abiBuffer) {
        byte[] unitBuffer = ABIType.newUnitBuffer();
        abiBuffer.get(unitBuffer, 0, 4);
        for (int i = 0; i < 4; ++i) {
            if (unitBuffer[i] == this.selector[i]) continue;
            throw new IllegalArgumentException("given selector does not match: expected: " + this.selectorHex() + ", found: " + Strings.encode(unitBuffer, 0, 4, 0));
        }
        return this.inputTypes.decode(abiBuffer, unitBuffer);
    }

    public Tuple decodeReturn(byte[] returnVals) {
        return this.outputTypes.decode(returnVals);
    }

    public Tuple decodeReturn(ByteBuffer returnVals) {
        return this.outputTypes.decode(returnVals);
    }

    public int hashCode() {
        return 31 * Objects.hash(new Object[]{this.type, this.name, this.inputTypes, this.outputTypes, this.hashAlgorithm, this.stateMutability}) + Arrays.hashCode(this.selector);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        return other.type == this.type && Objects.equals(other.name, this.name) && other.inputTypes.equals(this.inputTypes) && other.outputTypes.equals(this.outputTypes) && Arrays.equals(other.selector, this.selector) && other.hashAlgorithm.equals(this.hashAlgorithm) && Objects.equals(other.stateMutability, this.stateMutability);
    }

    public String toString() {
        return this.toJson(true);
    }

    @Override
    public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, true, pretty);
    }

    public static Function parse(String signature) {
        return new Function(signature);
    }

    public static Function parse(String signature, String outputs) {
        return new Function(signature, outputs);
    }

    public static Function parse(String signature, MessageDigest messageDigest) {
        return new Function(signature, null, messageDigest);
    }

    public static Function fromJson(String objectJson) {
        return Function.fromJsonObject(JsonUtils.parseObject(objectJson));
    }

    public static Function fromJson(String objectJson, MessageDigest messageDigest) {
        return Function.fromJsonObject(JsonUtils.parseObject(objectJson), messageDigest);
    }

    public static Function fromJsonObject(JsonObject function) {
        return Function.fromJsonObject(function, Function.newDefaultDigest());
    }

    public static Function fromJsonObject(JsonObject function, MessageDigest messageDigest) {
        return ABIJSON.parseFunction(function, messageDigest);
    }

    public static MessageDigest newDefaultDigest() {
        return new Keccak(256);
    }

    public static String formatCall(byte[] abiCall) {
        return Function.formatCall(abiCall, 0, abiCall.length);
    }

    public static String formatCall(byte[] buffer, int offset, int length) {
        return Function.formatCall(buffer, offset, length, row -> TupleType.pad(0, "" + row));
    }

    public static String formatCall(byte[] buffer, int offset, int length, TupleType.RowLabeler labeler) {
        Integers.checkIsMultiple(length - 4, 32);
        StringBuilder sb = new StringBuilder(TupleType.pad(0, "ID")).append(Strings.encode(buffer, offset, 4, 0));
        return TupleType.finishFormat(buffer, offset + 4, offset + length, labeler, sb);
    }

    public static enum Type {
        FUNCTION,
        RECEIVE,
        FALLBACK,
        CONSTRUCTOR;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

