/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.RandomAccess;

public final class Tuple
extends AbstractList<Object>
implements RandomAccess {
    public static final Tuple EMPTY = new Tuple(new Object[0]);
    final Object[] elements;

    public Tuple(Object ... elements) {
        this.elements = Arrays.copyOf(elements, elements.length);
    }

    @Override
    public Object get(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Tuple && Arrays.deepEquals(((Tuple)o).elements, this.elements);
    }

    @Override
    public String toString() {
        return Arrays.deepToString(this.elements);
    }

    public Tuple subtuple(int startIndex, int endIndex) {
        int len = endIndex - startIndex;
        Object[] copy = new Object[len];
        System.arraycopy(this.elements, startIndex, copy, 0, len);
        return new Tuple(copy);
    }

    public static Tuple of(Object ... elements) {
        return new Tuple(elements);
    }

    public static Tuple singleton(Object element) {
        return new Tuple(element);
    }
}

