/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

final class TypeFactory {
    private static final int ADDRESS_BIT_LEN = 160;
    private static final int DECIMAL_BIT_LEN = 128;
    private static final int DECIMAL_SCALE = 10;
    private static final int FIXED_BIT_LEN = 128;
    private static final int FIXED_SCALE = 18;
    private static final int FUNCTION_BYTE_LEN = 24;
    static final Map<String, Supplier<ABIType<?>>> SUPPLIER_MAP;
    static final String EMPTY_PARAMETER = "empty parameter";

    TypeFactory() {
    }

    private static void mapInt(Map<String, Supplier<ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, () -> new IntType(type, bitLen, unsigned));
    }

    private static void mapLong(Map<String, Supplier<ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, () -> new LongType(type, bitLen, unsigned));
    }

    private static void mapBigInteger(Map<String, Supplier<ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, () -> new BigIntegerType(type, bitLen, unsigned));
    }

    private static void mapByteArray(Map<String, Supplier<ABIType<?>>> map, String type, int arrayLen) {
        map.put(type, () -> new ArrayType<ByteType, byte[]>(type, byte[].class, ByteType.SIGNED, arrayLen, byte[][].class));
    }

    static ABIType<?> create(String rawType, String name) {
        return TypeFactory.buildType(rawType, null).setName(name);
    }

    static ABIType<?> createFromBase(TupleType baseType, String typeSuffix, String name) {
        return TypeFactory.buildType(baseType.canonicalType + typeSuffix, baseType).setName(name);
    }

    private static ABIType<?> buildType(String rawType, ABIType<?> baseType) {
        try {
            int lastCharIdx = rawType.length() - 1;
            if (rawType.charAt(lastCharIdx) == ']') {
                int secondToLastCharIdx = lastCharIdx - 1;
                int arrayOpenIndex = rawType.lastIndexOf(91, secondToLastCharIdx);
                ABIType<?> elementType = TypeFactory.buildType(rawType.substring(0, arrayOpenIndex), baseType);
                String type = elementType.canonicalType + rawType.substring(arrayOpenIndex);
                int length = arrayOpenIndex == secondToLastCharIdx ? -1 : TypeFactory.parseLen(rawType, arrayOpenIndex + 1, lastCharIdx);
                return new ArrayType(type, elementType.arrayClass(), elementType, length);
            }
            if (baseType != null || (baseType = TypeFactory.resolveBaseType(rawType)) != null) {
                return baseType;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException("unrecognized type: \"" + rawType + '\"');
    }

    private static int parseLen(String rawType, int startLen, int lastCharIndex) {
        try {
            String lengthStr = rawType.substring(startLen, lastCharIndex);
            int length = Integer.parseInt(lengthStr);
            if (length >= 0) {
                if (lengthStr.length() > 1 && rawType.charAt(startLen) == '0') {
                    throw new IllegalArgumentException("leading zero in array length");
                }
                return length;
            }
            throw new IllegalArgumentException("negative array length");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("illegal number format", nfe);
        }
    }

    private static ABIType<?> resolveBaseType(String baseTypeStr) {
        if (baseTypeStr.charAt(0) == '(') {
            return TypeFactory.parseTupleType(baseTypeStr);
        }
        Supplier<ABIType<?>> supplier = SUPPLIER_MAP.get(baseTypeStr);
        return supplier != null ? supplier.get() : TypeFactory.tryParseFixed(baseTypeStr);
    }

    private static BigDecimalType tryParseFixed(String type) {
        int idx = type.indexOf("fixed");
        boolean unsigned = false;
        if (idx == 0 || (unsigned = idx == 1 && type.charAt(0) == 'u')) {
            int indexOfX = type.lastIndexOf(120);
            try {
                String mStr = type.substring(idx + "fixed".length(), indexOfX);
                String nStr = type.substring(indexOfX + 1);
                if (!mStr.startsWith("0") && !nStr.startsWith("0")) {
                    int M = Integer.parseInt(mStr);
                    int N = Integer.parseInt(nStr);
                    if ((M & 7) == 0 && M >= 8 && M <= 256 && N > 0 && N <= 80) {
                        return new BigDecimalType((unsigned ? "ufixed" : "fixed") + M + 'x' + N, M, N, unsigned);
                    }
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static TupleType parseTupleType(String rawTypeStr) {
        ArrayList elements = new ArrayList();
        try {
            int argStart = 1;
            int argEnd = 1;
            int prevEndChar = 41;
            int end = rawTypeStr.length();
            block7: while (argStart < end) {
                switch (rawTypeStr.charAt(argStart)) {
                    case '(': {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, TypeFactory.findSubtupleEnd(rawTypeStr, argStart + 1));
                        break;
                    }
                    case ')': {
                        if (prevEndChar != 44) break block7;
                        throw new IllegalArgumentException(EMPTY_PARAMETER);
                    }
                    case ',': {
                        if (rawTypeStr.charAt(argEnd) == ')') break block7;
                        throw new IllegalArgumentException(EMPTY_PARAMETER);
                    }
                    default: {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, argStart + 1);
                    }
                }
                elements.add(TypeFactory.buildType(rawTypeStr.substring(argStart, argEnd), null));
                char c = rawTypeStr.charAt(argEnd);
                prevEndChar = c;
                if (c != ',') break;
                argStart = argEnd + 1;
            }
            if (argEnd == end - 1 && prevEndChar == 41) {
                return TupleType.wrap((ABIType[])elements.toArray(ABIType.EMPTY_TYPE_ARRAY));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("@ index " + elements.size() + ", " + iae.getMessage(), iae);
        }
        return null;
    }

    private static int findSubtupleEnd(String parentTypeString, int i) {
        int depth = 1;
        do {
            char x;
            if ((x = parentTypeString.charAt(i++)) > ')') continue;
            if (x == ')') {
                --depth;
                continue;
            }
            if (x != '(') continue;
            ++depth;
        } while (depth > 0);
        return i;
    }

    private static int nextTerminator(String signature, int i) {
        int comma = signature.indexOf(44, i);
        int close = signature.indexOf(41, i);
        return comma == -1 ? close : (close == -1 ? comma : Math.min(comma, close));
    }

    static {
        int n;
        HashMap lambdaMap = new HashMap(256);
        for (n = 8; n <= 32; n += 8) {
            TypeFactory.mapInt(lambdaMap, "int" + n, n, false);
        }
        for (n = 40; n <= 64; n += 8) {
            TypeFactory.mapLong(lambdaMap, "int" + n, n, false);
        }
        for (n = 72; n <= 256; n += 8) {
            TypeFactory.mapBigInteger(lambdaMap, "int" + n, n, false);
        }
        lambdaMap.put("int", (Supplier)lambdaMap.get("int256"));
        for (n = 8; n <= 24; n += 8) {
            TypeFactory.mapInt(lambdaMap, "uint" + n, n, true);
        }
        for (n = 32; n <= 56; n += 8) {
            TypeFactory.mapLong(lambdaMap, "uint" + n, n, true);
        }
        for (n = 64; n <= 256; n += 8) {
            TypeFactory.mapBigInteger(lambdaMap, "uint" + n, n, true);
        }
        lambdaMap.put("uint", (Supplier)lambdaMap.get("uint256"));
        for (n = 1; n <= 32; ++n) {
            TypeFactory.mapByteArray(lambdaMap, "bytes" + n, n);
        }
        TypeFactory.mapBigInteger(lambdaMap, "address", 160, true);
        TypeFactory.mapByteArray(lambdaMap, "function", 24);
        TypeFactory.mapByteArray(lambdaMap, "bytes", -1);
        lambdaMap.put("string", () -> new ArrayType<ByteType, String>("string", ArrayType.STRING_CLASS, ByteType.SIGNED, -1, ArrayType.STRING_ARRAY_CLASS));
        lambdaMap.put("fixed128x18", () -> new BigDecimalType("fixed128x18", 128, 18, false));
        lambdaMap.put("ufixed128x18", () -> new BigDecimalType("ufixed128x18", 128, 18, true));
        lambdaMap.put("fixed", (Supplier)lambdaMap.get("fixed128x18"));
        lambdaMap.put("ufixed", (Supplier)lambdaMap.get("ufixed128x18"));
        lambdaMap.put("decimal", () -> new BigDecimalType("decimal", 128, 10, false));
        lambdaMap.put("bool", BooleanType::new);
        SUPPLIER_MAP = Collections.unmodifiableMap(lambdaMap);
    }
}

