/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.util.BizarroIntegers;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class UnitType<J>
extends ABIType<J> {
    public static final int UNIT_LENGTH_BYTES = 32;
    final int bitLength;
    final boolean unsigned;

    UnitType(String canonicalType, Class<J> clazz, int bitLength, boolean unsigned) {
        super(canonicalType, clazz, false);
        this.bitLength = bitLength;
        this.unsigned = unsigned;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    final int byteLength(Object value) {
        return 32;
    }

    @Override
    int byteLengthPacked(Object value) {
        return this.bitLength / 8;
    }

    @Override
    public int validate(Object value) {
        this.validateClass(value);
        this.validatePrimitive(((Number)value).longValue());
        return 32;
    }

    @Override
    int encodeHead(Object value, ByteBuffer dest, int nextOffset) {
        Encoding.insertInt(((Number)value).longValue(), dest);
        return nextOffset;
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        this.encodeHead(value, dest, 0);
    }

    final void validatePrimitive(long longVal) {
        if (longVal < 0L) {
            if (this.unsigned) {
                throw new IllegalArgumentException("signed value given for unsigned type");
            }
            this.checkBitLen(BizarroIntegers.bitLen(longVal));
        } else {
            this.checkBitLen(Integers.bitLen(longVal));
        }
    }

    final void validateBigInt(BigInteger bigIntVal) {
        if (this.unsigned && bigIntVal.signum() < 0) {
            throw new IllegalArgumentException("signed value given for unsigned type");
        }
        this.checkBitLen(bigIntVal.bitLength());
    }

    final void checkBitLen(int actual) {
        if (this.unsigned) {
            if (actual > this.bitLength) {
                throw new IllegalArgumentException("unsigned val exceeds bit limit: " + actual + " > " + this.bitLength);
            }
        } else if (actual >= this.bitLength) {
            throw new IllegalArgumentException("signed val exceeds bit limit: " + actual + " >= " + this.bitLength);
        }
    }

    protected final BigInteger decodeValid(ByteBuffer bb, byte[] unitBuffer) {
        int idx = 0;
        if (this.unsigned) {
            unitBuffer = new byte[33];
            idx = 1;
        }
        bb.get(unitBuffer, idx, 32);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi;
    }
}

