/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi.util;

import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;

public final class BizarroIntegers {
    public static byte[] toBytes(byte val) {
        byte[] byArray;
        if (val != -1) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = val;
        } else {
            byArray = Strings.EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public static byte[] toBytes(short val) {
        byte[] bytes = new byte[BizarroIntegers.len(val)];
        BizarroIntegers.putShort(val, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(int val) {
        byte[] bytes = new byte[BizarroIntegers.len(val)];
        BizarroIntegers.putInt(val, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(long val) {
        byte[] bytes = new byte[BizarroIntegers.len(val)];
        BizarroIntegers.putLong(val, bytes, 0);
        return bytes;
    }

    public static int putByte(byte val, byte[] o, int i) {
        if (val != -1) {
            o[i] = val;
            return 1;
        }
        return 0;
    }

    public static int putShort(short val, byte[] o, int i) {
        int v = val;
        if (val != -1) {
            byte b = (byte)v;
            if ((v >>= 8) != -1) {
                o[i] = (byte)v;
                o[i + 1] = b;
                return 2;
            }
            o[i] = b;
            return 1;
        }
        return 0;
    }

    public static int putInt(int val, byte[] o, int i) {
        if (val != -1) {
            byte d = (byte)val;
            if ((val >>= 8) != -1) {
                byte c = (byte)val;
                if ((val >>= 8) != -1) {
                    byte b = (byte)val;
                    if ((val >>= 8) != -1) {
                        o[i] = (byte)val;
                        o[i + 1] = b;
                        o[i + 2] = c;
                        o[i + 3] = d;
                        return 4;
                    }
                    o[i] = b;
                    o[i + 1] = c;
                    o[i + 2] = d;
                    return 3;
                }
                o[i] = c;
                o[i + 1] = d;
                return 2;
            }
            o[i] = d;
            return 1;
        }
        return 0;
    }

    public static int putLong(long val, byte[] o, int i) {
        if (val != -1L) {
            byte h = (byte)val;
            if ((val >>= 8) != -1L) {
                byte g = (byte)val;
                if ((val >>= 8) != -1L) {
                    byte f = (byte)val;
                    if ((val >>= 8) != -1L) {
                        byte e = (byte)val;
                        if ((val >>= 8) != -1L) {
                            byte d = (byte)val;
                            if ((val >>= 8) != -1L) {
                                byte c = (byte)val;
                                if ((val >>= 8) != -1L) {
                                    byte b = (byte)val;
                                    if ((val >>= 8) != -1L) {
                                        o[i] = (byte)val;
                                        o[i + 1] = b;
                                        o[i + 2] = c;
                                        o[i + 3] = d;
                                        o[i + 4] = e;
                                        o[i + 5] = f;
                                        o[i + 6] = g;
                                        o[i + 7] = h;
                                        return 8;
                                    }
                                    o[i] = b;
                                    o[i + 1] = c;
                                    o[i + 2] = d;
                                    o[i + 3] = e;
                                    o[i + 4] = f;
                                    o[i + 5] = g;
                                    o[i + 6] = h;
                                    return 7;
                                }
                                o[i] = c;
                                o[i + 1] = d;
                                o[i + 2] = e;
                                o[i + 3] = f;
                                o[i + 4] = g;
                                o[i + 5] = h;
                                return 6;
                            }
                            o[i] = d;
                            o[i + 1] = e;
                            o[i + 2] = f;
                            o[i + 3] = g;
                            o[i + 4] = h;
                            return 5;
                        }
                        o[i] = e;
                        o[i + 1] = f;
                        o[i + 2] = g;
                        o[i + 3] = h;
                        return 4;
                    }
                    o[i] = f;
                    o[i + 1] = g;
                    o[i + 2] = h;
                    return 3;
                }
                o[i] = g;
                o[i + 1] = h;
                return 2;
            }
            o[i] = h;
            return 1;
        }
        return 0;
    }

    public static int putLong(long val, ByteBuffer o) {
        if (val != -1L) {
            byte h = (byte)val;
            if ((val >>= 8) != -1L) {
                byte g = (byte)val;
                if ((val >>= 8) != -1L) {
                    byte f = (byte)val;
                    if ((val >>= 8) != -1L) {
                        byte e = (byte)val;
                        if ((val >>= 8) != -1L) {
                            byte d = (byte)val;
                            if ((val >>= 8) != -1L) {
                                byte c = (byte)val;
                                if ((val >>= 8) != -1L) {
                                    byte b = (byte)val;
                                    if ((val >>= 8) != -1L) {
                                        o.put((byte)val).put(b).put(c).put(d).put(e).put(f).put(g).put(h);
                                        return 8;
                                    }
                                    o.put(b).put(c).put(d).put(e).put(f).put(g).put(h);
                                    return 7;
                                }
                                o.put(c).put(d).put(e).put(f).put(g).put(h);
                                return 6;
                            }
                            o.put(d).put(e).put(f).put(g).put(h);
                            return 5;
                        }
                        o.put(e).put(f).put(g).put(h);
                        return 4;
                    }
                    o.put(f).put(g).put(h);
                    return 3;
                }
                o.put(g).put(h);
                return 2;
            }
            o.put(h);
            return 1;
        }
        return 0;
    }

    private static int _getShortInt(byte[] buffer, int i) {
        return buffer[i + 1] & 0xFF | (buffer[i] & 0xFF) << 8;
    }

    private static int _getInt(byte[] buffer, int offset, int len) {
        int shiftAmount = 0;
        int val = 0;
        switch (len) {
            case 4: {
                val = buffer[offset + 3] & 0xFF;
                shiftAmount = 8;
            }
            case 3: {
                val |= (buffer[offset + 2] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= (buffer[offset + 1] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                val |= (buffer[offset] & 0xFF) << shiftAmount;
            }
        }
        return val;
    }

    private static long _getLong(byte[] buffer, int offset, int len) {
        int shiftAmount = 0;
        long val = 0L;
        switch (len) {
            case 8: {
                val = (long)buffer[offset + 7] & 0xFFL;
                shiftAmount = 8;
            }
            case 7: {
                val |= ((long)buffer[offset + 6] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 6: {
                val |= ((long)buffer[offset + 5] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 5: {
                val |= ((long)buffer[offset + 4] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 4: {
                val |= ((long)buffer[offset + 3] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 3: {
                val |= ((long)buffer[offset + 2] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= ((long)buffer[offset + 1] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                val |= ((long)buffer[offset] & 0xFFL) << shiftAmount;
            }
        }
        return val;
    }

    public static byte getByte(byte[] buffer, int offset, int len) {
        switch (len) {
            case 0: {
                return -1;
            }
            case 1: {
                return buffer[offset];
            }
        }
        throw BizarroIntegers.outOfRangeException(len);
    }

    public static short getShort(byte[] buffer, int offset, int len) {
        switch (len) {
            case 0: {
                return -1;
            }
            case 1: {
                return (short)(0xFFFFFF00 | buffer[offset]);
            }
            case 2: {
                return (short)BizarroIntegers._getShortInt(buffer, offset);
            }
        }
        throw BizarroIntegers.outOfRangeException(len);
    }

    public static int getInt(byte[] buffer, int offset, int len) {
        switch (len) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0xFFFFFF00 | buffer[offset];
            }
            case 2: {
                return 0xFFFF0000 | BizarroIntegers._getShortInt(buffer, offset);
            }
            case 3: {
                return 0xFF000000 | BizarroIntegers._getInt(buffer, offset, 3);
            }
            case 4: {
                return BizarroIntegers._getInt(buffer, offset, 4);
            }
        }
        throw BizarroIntegers.outOfRangeException(len);
    }

    public static long getLong(byte[] buffer, int offset, int len) {
        switch (len) {
            case 0: {
                return -1L;
            }
            case 1: {
                return 0xFFFFFFFFFFFFFF00L | (long)buffer[offset];
            }
            case 2: {
                return 0xFFFFFFFFFFFF0000L | (long)BizarroIntegers._getShortInt(buffer, offset);
            }
            case 3: {
                return 0xFFFFFFFFFF000000L | (long)BizarroIntegers._getInt(buffer, offset, 3);
            }
            case 4: {
                return 0xFFFFFFFF00000000L | (long)BizarroIntegers._getInt(buffer, offset, 4);
            }
            case 5: {
                return 0xFFFFFF0000000000L | BizarroIntegers._getLong(buffer, offset, 5);
            }
            case 6: {
                return 0xFFFF000000000000L | BizarroIntegers._getLong(buffer, offset, 6);
            }
            case 7: {
                return 0xFF00000000000000L | BizarroIntegers._getLong(buffer, offset, 7);
            }
            case 8: {
                return BizarroIntegers._getLong(buffer, offset, 8);
            }
        }
        throw BizarroIntegers.outOfRangeException(len);
    }

    private static IllegalArgumentException outOfRangeException(int len) {
        return new IllegalArgumentException("len is out of range: " + len);
    }

    public static int len(byte val) {
        return val != -1 ? 1 : 0;
    }

    public static int len(short val) {
        if (val != -1) {
            if (val >> 8 != -1) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int len(int val) {
        if (val != -1) {
            if ((val >>= 8) != -1) {
                if ((val >>= 8) != -1) {
                    if (val >> 8 != -1) {
                        return 4;
                    }
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int len(long val) {
        if (val != -1L) {
            if ((val >>= 8) != -1L) {
                if ((val >>= 8) != -1L) {
                    if ((val >>= 8) != -1L) {
                        if ((val >>= 8) != -1L) {
                            if ((val >>= 8) != -1L) {
                                if ((val >>= 8) != -1L) {
                                    if (val >> 8 != -1L) {
                                        return 8;
                                    }
                                    return 7;
                                }
                                return 6;
                            }
                            return 5;
                        }
                        return 4;
                    }
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int bitLen(long val) {
        return 64 - Long.numberOfLeadingZeros(val ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

