/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.util.Strings;
import java.util.Arrays;
import java.util.Comparator;

public final class KeyValuePair
implements Comparable<KeyValuePair> {
    public static final Comparator<KeyValuePair> PAIR_COMPARATOR = (pa, pb) -> {
        byte[] a = pa.key;
        byte[] b = pb.key;
        if (a != b) {
            int result;
            int i;
            int len = Math.min(a.length, b.length);
            boolean mismatch = false;
            for (i = 0; i < len; ++i) {
                if (a[i] == b[i]) continue;
                mismatch = true;
                break;
            }
            int n = result = mismatch ? a[i] - b[i] : a.length - b.length;
            if (result != 0) {
                return result;
            }
        }
        throw new IllegalArgumentException("duplicate key: " + Strings.encode(a, 1));
    };
    public static final String ID = "id";
    public static final String SECP256K1 = "secp256k1";
    public static final String IP = "ip";
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    public static final String IP6 = "ip6";
    public static final String TCP6 = "tcp6";
    public static final String UDP6 = "udp6";
    private final byte[] key;
    private final byte[] value;

    public KeyValuePair(String key, String value, int valueEncoding) {
        this.key = Strings.decode(key, 1);
        this.value = Strings.decode(value, valueEncoding);
    }

    public KeyValuePair(byte[] key, byte[] value) {
        this.key = Arrays.copyOf(key, key.length);
        this.value = Arrays.copyOf(value, value.length);
    }

    public byte[] getKey() {
        return Arrays.copyOf(this.key, this.key.length);
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof KeyValuePair && Arrays.equals(((KeyValuePair)o).key, this.key);
    }

    public String toString() {
        return Strings.encode(this.key, 1) + " --> " + Strings.encode(this.value, 0);
    }

    @Override
    public int compareTo(KeyValuePair other) {
        return PAIR_COMPARATOR.compare(this, other);
    }
}

