/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.util.Integers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class RLPList
extends RLPItem
implements Iterable<RLPItem> {
    RLPList(byte lead, DataType type, byte[] buffer, int index, int containerEnd, boolean lenient) {
        super(lead, type, buffer, index, containerEnd, lenient);
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public RLPString asRLPString() {
        throw new ClassCastException("not an " + RLPString.class.getSimpleName());
    }

    @Override
    public RLPList asRLPList() {
        return this;
    }

    static RLPList withElements(Iterable<RLPItem> elements) {
        int dataLen = 0;
        for (RLPItem e : elements) {
            dataLen += e.encodingLength();
        }
        return RLPDecoder.RLP_STRICT.wrapList(dataLen < 56 ? RLPList.encodeListShort(dataLen, elements) : RLPList.encodeListLong(dataLen, elements));
    }

    private static byte[] encodeListShort(int dataLen, Iterable<RLPItem> elements) {
        byte[] dest = new byte[1 + dataLen];
        dest[0] = (byte)(-64 + dataLen);
        RLPList.copyElements(elements, dest, 1);
        return dest;
    }

    private static byte[] encodeListLong(int dataLen, Iterable<RLPItem> elements) {
        int lengthOfLength = Integers.len(dataLen);
        int prefixLen = 1 + lengthOfLength;
        byte[] dest = new byte[prefixLen + dataLen];
        dest[0] = (byte)(-9 + lengthOfLength);
        Integers.putLong(dataLen, dest, 1);
        RLPList.copyElements(elements, dest, prefixLen);
        return dest;
    }

    private static void copyElements(Iterable<RLPItem> elements, byte[] dest, int destIndex) {
        for (RLPItem e : elements) {
            destIndex = e.export(dest, destIndex);
        }
    }

    public List<RLPItem> elements() {
        return this.elements(RLPDecoder.RLP_STRICT);
    }

    public List<RLPItem> elements(RLPDecoder decoder) {
        ArrayList<RLPItem> arrayList = new ArrayList<RLPItem>();
        this.elements(decoder, arrayList);
        return arrayList;
    }

    public void elements(RLPDecoder decoder, Collection<RLPItem> collection) {
        int i = this.dataIndex;
        while (i < this.endIndex) {
            RLPItem item = decoder.wrap(this.buffer, i, this.endIndex);
            collection.add(item);
            i = item.endIndex;
        }
    }

    @Override
    public RLPList duplicate(RLPDecoder decoder) {
        return decoder.wrapList(this.encoding());
    }

    public Iterator<RLPItem> iterator(RLPDecoder decoder) {
        return new RLPListIterator(decoder, this);
    }

    @Override
    public Iterator<RLPItem> iterator() {
        return this.iterator(RLPDecoder.RLP_STRICT);
    }

    private static final class RLPListIterator
    implements Iterator<RLPItem> {
        private final RLPDecoder decoder;
        private final byte[] buffer;
        private int idx;
        private final int endIndex;

        RLPListIterator(RLPDecoder decoder, RLPList rlpList) {
            this.decoder = decoder;
            this.buffer = rlpList.buffer;
            this.idx = rlpList.dataIndex;
            this.endIndex = rlpList.endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.endIndex;
        }

        @Override
        public RLPItem next() {
            if (this.hasNext()) {
                RLPItem next = this.decoder.wrap(this.buffer, this.idx, this.endIndex);
                this.idx = next.endIndex;
                return next;
            }
            throw new NoSuchElementException();
        }
    }
}

