/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp.util;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.util.NotationParser;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Notation {
    private static final boolean LENIENT = true;
    private static final String BEGIN_NOTATION = "(";
    private static final String END_NOTATION = "\n)";
    static final String BEGIN_LIST = "[";
    static final String END_LIST = "]";
    static final String BEGIN_STRING = "'";
    static final String END_STRING = "'";
    private static final String DELIMITER = ",";
    private static final String SHORT_LIST_START = "[ ";
    private static final String DELIMITER_SPACE = ", ";
    private static final String STRING_DELIMIT_SPACE = "', ";
    private static final String STRING_DELIMIT = "',";
    private static final String SHORT_LIST_END = " ], ";
    private static final String SHORT_LIST_END_NO_SPACE = " ],";
    private static final String LONG_LIST_END = "],";
    private static final String[] LINE_PADDING_CACHE = new String[8];
    private final String value;

    private Notation(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public List<Object> parse() {
        return NotationParser.parse(this.value);
    }

    public static Notation forEncoding(byte[] encoding) {
        return Notation.forEncoding(encoding, 0, encoding.length);
    }

    public static Notation forEncoding(byte[] buffer, int index, int end) {
        if (index >= 0) {
            if (index <= (end = Math.min(buffer.length, end))) {
                StringBuilder sb = new StringBuilder(BEGIN_NOTATION);
                Notation.buildLongList(sb, buffer, index, end, 0);
                return new Notation(sb.append(END_NOTATION).toString());
            }
            throw new IllegalArgumentException("index > end: " + index + " > " + end);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public static Notation forObjects(Object ... objects) {
        return Notation.forEncoding(RLPEncoder.encodeSequentially(objects));
    }

    public static Notation forObjects(Iterable<Object> objects) {
        return Notation.forEncoding(RLPEncoder.encodeSequentially(objects));
    }

    private static RuntimeException exceedsContainer(int index, long end, int containerEnd) {
        return new IllegalArgumentException("element @ index " + index + " exceeds its container: " + end + " > " + containerEnd);
    }

    private static int getShortElementEnd(int elementDataIndex, int elementDataLen, int containerEnd) {
        int end = elementDataIndex + elementDataLen;
        if (end <= containerEnd) {
            return end;
        }
        throw Notation.exceedsContainer(elementDataIndex - 1, end, containerEnd);
    }

    private static int getLongElementEnd(byte[] data, int leadByteIndex, int dataIndex, int containerEnd) {
        if (dataIndex <= containerEnd) {
            int lengthIndex = leadByteIndex + 1;
            int lengthLen = dataIndex - lengthIndex;
            long dataLenLong = Integers.getLong(data, leadByteIndex + 1, lengthLen, true);
            long end = (long)(lengthIndex + lengthLen) + dataLenLong;
            if (end > (long)containerEnd) {
                throw Notation.exceedsContainer(leadByteIndex, end, containerEnd);
            }
            int dataLen = (int)dataLenLong;
            if (dataLen >= 56) {
                return (int)end;
            }
            throw new IllegalArgumentException("long element data length must be 56 or greater; found: " + dataLen + " for element @ " + leadByteIndex);
        }
        throw Notation.exceedsContainer(leadByteIndex, dataIndex, containerEnd);
    }

    private static int buildString(StringBuilder sb, byte[] data, int from, int to, boolean addSpace) {
        int len = to - from;
        sb.append("'").append(Strings.encode(data, from, len, 0)).append(addSpace ? STRING_DELIMIT_SPACE : STRING_DELIMIT);
        return to;
    }

    private static int buildLongList(StringBuilder sb, byte[] data, int dataIndex, int end, int depth) {
        if (depth != 0) {
            sb.append(BEGIN_LIST);
        }
        Notation.buildListContent(sb, dataIndex, end, data, false, depth + 1);
        if (depth != 0) {
            sb.append(Notation.getLinePadding(depth)).append(LONG_LIST_END);
        }
        return end;
    }

    private static int buildShortList(StringBuilder sb, byte[] data, int dataIndex, int end, int depth, boolean addSpace) {
        sb.append(SHORT_LIST_START);
        Notation.buildListContent(sb, dataIndex, end, data, true, depth + 1);
        sb.append(addSpace ? SHORT_LIST_END : SHORT_LIST_END_NO_SPACE);
        return end;
    }

    private static void buildListContent(StringBuilder sb, int dataIndex, int end, byte[] data, boolean shortList, int elementDepth) {
        String elementPrefix = shortList ? null : Notation.getLinePadding(elementDepth);
        int i = dataIndex;
        while (i < end) {
            int elementEnd;
            byte lead;
            DataType type;
            if (!shortList) {
                sb.append(elementPrefix);
            }
            if ((type = DataType.type(lead = data[i])) == DataType.SINGLE_BYTE) {
                i = Notation.buildString(sb, data, i, i + 1, shortList);
                continue;
            }
            if (type.isLong && shortList) {
                throw new IllegalArgumentException("long element found in short list");
            }
            int diff = lead - type.offset;
            int elementDataIdx = i + 1 + (type.isLong ? diff : 0);
            int n = elementEnd = type.isLong ? Notation.getLongElementEnd(data, i, elementDataIdx, end) : Notation.getShortElementEnd(elementDataIdx, diff, end);
            i = type.isString ? Notation.buildString(sb, data, elementDataIdx, elementEnd, shortList) : (type.isLong ? Notation.buildLongList(sb, data, elementDataIdx, elementEnd, elementDepth) : Notation.buildShortList(sb, data, elementDataIdx, elementEnd, elementDepth, shortList));
        }
        if (dataIndex != end) {
            sb.replace(sb.length() - (shortList ? DELIMITER_SPACE : DELIMITER).length(), sb.length(), "");
        }
    }

    private static String getLinePadding(int depth) {
        return depth < LINE_PADDING_CACHE.length ? LINE_PADDING_CACHE[depth] : Notation.newLinePadding(depth);
    }

    private static String newLinePadding(int depth) {
        byte[] prefix = new byte[1 + depth * 2];
        Arrays.fill(prefix, (byte)32);
        prefix[0] = 10;
        return new String(prefix, 0, 0, prefix.length);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Notation && ((Notation)o).value.equals(this.value);
    }

    public String toString() {
        return this.value;
    }

    static {
        for (int i = 0; i < LINE_PADDING_CACHE.length; ++i) {
            Notation.LINE_PADDING_CACHE[i] = Notation.newLinePadding(i);
        }
    }
}

