/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp.util;

import com.esaulpaugh.headlong.util.Strings;
import java.util.ArrayList;
import java.util.List;

public final class NotationParser {
    private static final int LIST = 0;
    private static final int STRING = 1;
    private static final int LIST_PREFIX_LEN = "[".length();
    private static final int LIST_SUFFIX_LEN = "]".length();
    private static final int STRING_PREFIX_LEN = "'".length();
    private static final int STRING_SUFFIX_LEN = "'".length();

    public static List<Object> parse(String notation) {
        ArrayList<Object> topLevelObjects = new ArrayList<Object>();
        NotationParser.parse(notation, 0, notation.length(), topLevelObjects, new int[2]);
        return topLevelObjects;
    }

    private static int parse(String notation, int i, int end, List<Object> parent, int[] resultHolder) {
        int nextArrayEnd = -1;
        while (i < end) {
            int nextObjectIndex;
            if (!NotationParser.findNextObject(notation, i, resultHolder)) {
                return Integer.MAX_VALUE;
            }
            if (i > nextArrayEnd && (nextArrayEnd = notation.indexOf("]", i)) < 0) {
                nextArrayEnd = Integer.MAX_VALUE;
            }
            if (nextArrayEnd < (nextObjectIndex = resultHolder[0])) {
                return nextArrayEnd + LIST_SUFFIX_LEN;
            }
            if (1 == resultHolder[1]) {
                int datumStart = nextObjectIndex + STRING_PREFIX_LEN;
                int datumEnd = notation.indexOf("'", datumStart);
                if (datumEnd < 0) {
                    throw new IllegalArgumentException("unterminated string @ " + datumStart);
                }
                parent.add(Strings.decode(notation.substring(datumStart, datumEnd)));
                i = datumEnd + STRING_SUFFIX_LEN;
                continue;
            }
            ArrayList<Object> childList = new ArrayList<Object>();
            i = NotationParser.parse(notation, nextObjectIndex + LIST_PREFIX_LEN, end, childList, resultHolder);
            parent.add(childList);
        }
        return end + LIST_SUFFIX_LEN;
    }

    private static boolean findNextObject(String notation, int startIndex, int[] resultHolder) {
        int indexString = notation.indexOf("'", startIndex);
        int indexList = notation.indexOf("[", startIndex);
        if (indexString == -1) {
            if (indexList == -1) {
                return false;
            }
        } else if (indexString < indexList || indexList == -1) {
            resultHolder[0] = indexString;
            resultHolder[1] = 1;
            return true;
        }
        resultHolder[0] = indexList;
        resultHolder[1] = 0;
        return true;
    }
}

