/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

public final class JsonUtils {
    public static JsonElement parse(String json) {
        return JsonParser.parseString((String)json);
    }

    public static JsonObject parseObject(String json) {
        return JsonUtils.parse(json).getAsJsonObject();
    }

    public static JsonArray parseArray(String json) {
        return JsonUtils.parse(json).getAsJsonArray();
    }

    public static String getString(JsonObject object, String key) {
        return JsonUtils.getString(object, key, null);
    }

    public static boolean getBoolean(JsonObject object, String key) {
        return JsonUtils.getBoolean(object, key, null);
    }

    public static JsonArray getArray(JsonObject object, String key) {
        return JsonUtils.getArray(object, key, null);
    }

    public static String getString(JsonObject object, String key, String defaultVal) {
        JsonElement element = object.get(key);
        if (JsonUtils.isNull(element)) {
            return defaultVal;
        }
        if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
            return element.getAsString();
        }
        throw new IllegalArgumentException(key + " is not a string");
    }

    public static boolean getBoolean(JsonObject object, String key, Boolean defaultVal) {
        JsonElement element = object.get(key);
        if (JsonUtils.isNull(element)) {
            return defaultVal;
        }
        if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
            return element.getAsBoolean();
        }
        throw new IllegalArgumentException(key + " is not a boolean");
    }

    public static JsonArray getArray(JsonObject object, String key, JsonArray defaultVal) {
        JsonElement element = object.get(key);
        if (JsonUtils.isNull(element)) {
            return defaultVal;
        }
        return element.getAsJsonArray();
    }

    private static boolean isNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }

    public static String toPrettyPrint(JsonElement element) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(element);
    }
}

