/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.FastBase64;
import com.esaulpaugh.headlong.util.FastHex;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class Strings {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int BASE_64_URL_SAFE = 2;
    public static final int UTF_8 = 1;
    public static final int HEX = 0;
    public static final int URL_SAFE_FLAGS = 7;

    public static String encode(byte b) {
        return Strings.encode(new byte[]{b});
    }

    public static String encode(ByteBuffer buffer) {
        return Strings.encode(buffer.array());
    }

    public static String encode(byte[] bytes) {
        return Strings.encode(bytes, 0);
    }

    public static String encode(byte[] bytes, int encoding) {
        return Strings.encode(bytes, 0, bytes.length, encoding);
    }

    public static String encode(byte[] buffer, int from, int len, int encoding) {
        switch (encoding) {
            case 2: {
                return FastBase64.encodeToString(buffer, from, len, 7);
            }
            case 1: {
                return new String(buffer, from, len, StandardCharsets.UTF_8);
            }
            case 0: {
                return FastHex.encodeToString(buffer, from, len);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static byte[] decode(String encoded) {
        return Strings.decode(encoded, 0);
    }

    public static byte[] decode(String string, int encoding) {
        if (string.isEmpty()) {
            return EMPTY_BYTE_ARRAY;
        }
        switch (encoding) {
            case 2: {
                return Base64.getUrlDecoder().decode(string);
            }
            case 1: {
                return string.getBytes(StandardCharsets.UTF_8);
            }
            case 0: {
                return FastHex.decode(string, 0, string.length());
            }
        }
        throw new UnsupportedOperationException();
    }
}

