/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.abi.util.BizarroIntegers;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.util.Notation;
import com.esaulpaugh.headlong.rlp.util.NotationParser;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class SuperSerial {
    private static final byte[] TRUE = new byte[]{1};
    private static final byte[] FALSE = new byte[0];
    private static final int SIGN_BIT_MASK = 128;

    public static String serialize(TupleType tupleType, Tuple tuple, boolean machine) {
        tupleType.validate(tuple);
        Object[] objects = SuperSerial.serializeTuple(tupleType, tuple);
        return machine ? Strings.encode(RLPEncoder.encodeSequentially(objects)) : Notation.forObjects(objects).toString();
    }

    public static Tuple deserialize(TupleType tupleType, String str, boolean machine) {
        Tuple in = SuperSerial.deserializeTuple(tupleType, machine ? Strings.decode(str) : RLPEncoder.encodeSequentially(NotationParser.parse(str)));
        tupleType.validate(in);
        return in;
    }

    public static <T> T deserializeArray(ArrayType<? extends ABIType<?>, ?> arrayType, String str, boolean machine, Class<T> classOfT) {
        byte[] rlp = machine ? Strings.decode(str) : RLPEncoder.encodeSequentially(NotationParser.parse(str));
        Object array = SuperSerial.deserializeArray(arrayType, RLPDecoder.RLP_STRICT.wrap(rlp));
        arrayType.validate(array);
        return classOfT.cast(array);
    }

    private static Object[] serializeTuple(TupleType tupleType, Object obj) {
        Tuple tuple = (Tuple)obj;
        int len = tupleType.size();
        Object[] out = new Object[len];
        for (int i = 0; i < len; ++i) {
            out[i] = SuperSerial.serialize(tupleType.get(i), tuple.get(i));
        }
        return out;
    }

    private static Tuple deserializeTuple(TupleType tupleType, byte[] sequence) {
        Iterator<RLPItem> sequenceIterator = RLPDecoder.RLP_STRICT.sequenceIterator(sequence);
        int len = tupleType.size();
        Object[] elements = new Object[len];
        for (int i = 0; i < len; ++i) {
            elements[i] = SuperSerial.deserialize(tupleType.get(i), sequenceIterator.next());
        }
        if (sequenceIterator.hasNext()) {
            throw new IllegalArgumentException("trailing unconsumed items");
        }
        return new Tuple(elements);
    }

    private static Object serialize(ABIType<?> type, Object obj) {
        int typeCode = type.typeCode();
        switch (typeCode) {
            case 0: {
                return SuperSerial.serializeBoolean((Boolean)obj);
            }
            case 1: {
                return Integers.toBytes((Byte)obj);
            }
            case 2: {
                return SuperSerial.toSigned(((IntType)type).getBitLength(), BigInteger.valueOf(((Integer)obj).intValue()));
            }
            case 3: {
                return SuperSerial.toSigned(((LongType)type).getBitLength(), BigInteger.valueOf((Long)obj));
            }
            case 4: 
            case 5: {
                return SuperSerial.serializeBigInteger((UnitType)type, typeCode == 4 ? (BigInteger)obj : ((BigDecimal)obj).unscaledValue());
            }
            case 6: {
                return SuperSerial.serializeArray((ArrayType)type, obj);
            }
            case 7: {
                return SuperSerial.serializeTuple((TupleType)type, obj);
            }
        }
        throw new Error();
    }

    private static byte[] serializeBoolean(boolean val) {
        return val ? TRUE : FALSE;
    }

    private static Object serializeBigInteger(UnitType<?> ut, BigInteger bigInt) {
        return ut.isUnsigned() ? Integers.toBytesUnsigned(bigInt) : SuperSerial.toSigned(ut.getBitLength(), bigInt);
    }

    private static Object deserialize(ABIType<?> type, RLPItem item) {
        int typeCode = type.typeCode();
        if (typeCode < 6 && item.isList()) {
            throw new IllegalArgumentException("RLPList not allowed for this type: " + type + "\n" + item);
        }
        switch (typeCode) {
            case 0: {
                return item.asBoolean();
            }
            case 1: {
                return item.asByte(false);
            }
            case 2: 
            case 3: {
                return SuperSerial.deserializePrimitive((UnitType)type, item, typeCode == 2);
            }
            case 4: 
            case 5: {
                UnitType ut = (UnitType)type;
                BigInteger bigInt = SuperSerial.deserializeBigInteger(ut, item);
                return typeCode == 4 ? bigInt : new BigDecimal(bigInt, ((BigDecimalType)ut).getScale());
            }
            case 6: {
                return SuperSerial.deserializeArray((ArrayType)type, item);
            }
            case 7: {
                return SuperSerial.deserializeTuple((TupleType)type, item.asBytes());
            }
        }
        throw new Error();
    }

    private static Number deserializePrimitive(UnitType<?> ut, RLPItem item, boolean isInt) {
        if (ut.isUnsigned() || item.dataLength * 8 < ut.getBitLength()) {
            return isInt ? (Number)item.asInt(false) : (Number)item.asLong(false);
        }
        byte[] data = item.data();
        int len = data.length;
        if (len > 0 && (data[0] & 0x80) != 0) {
            return isInt ? (Number)BizarroIntegers.getInt(data, 0, len) : (Number)BizarroIntegers.getLong(data, 0, len);
        }
        return isInt ? (Number)Integers.getInt(data, 0, len, false) : (Number)Integers.getLong(data, 0, len, false);
    }

    private static BigInteger deserializeBigInteger(UnitType<?> ut, RLPItem item) {
        return ut.isUnsigned() ? item.asBigInt(false) : SuperSerial.asSigned(ut.getBitLength(), item);
    }

    private static byte[] toSigned(int typeBits, BigInteger val) {
        int signum = val.signum();
        if (signum != 0) {
            byte[] bytes = val.toByteArray();
            return signum < 0 ? SuperSerial.signExtendNegative(bytes, typeBits / 8) : (bytes[0] != 0 ? bytes : Arrays.copyOfRange(bytes, 1, bytes.length));
        }
        return Strings.EMPTY_BYTE_ARRAY;
    }

    private static byte[] signExtendNegative(byte[] negative, int newWidth) {
        byte[] extended = new byte[newWidth];
        Arrays.fill(extended, (byte)-1);
        System.arraycopy(negative, 0, extended, newWidth - negative.length, negative.length);
        return extended;
    }

    private static BigInteger asSigned(int typeBits, RLPItem item) {
        int dataLen = item.dataLength;
        if (dataLen != 0) {
            if (dataLen * 8 < typeBits) {
                byte[] padded = new byte[dataLen + 1];
                item.exportData(padded, 1);
                return new BigInteger(padded);
            }
            if (dataLen > 32) {
                throw new IllegalArgumentException("integer data cannot exceed 32 bytes");
            }
            return item.asBigIntSigned();
        }
        return BigInteger.ZERO;
    }

    private static Object serializeArray(ArrayType<? extends ABIType<?>, ?> arrayType, Object arr) {
        ABIType<?> elementType = arrayType.getElementType();
        switch (elementType.typeCode()) {
            case 0: {
                return SuperSerial.serializeBooleanArray((boolean[])arr);
            }
            case 1: {
                return SuperSerial.serializeByteArray(arr, arrayType.isString());
            }
            case 2: {
                return SuperSerial.serializeIntArray((int[])arr);
            }
            case 3: {
                return SuperSerial.serializeLongArray((long[])arr);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return SuperSerial.serializeObjectArray(arr, elementType);
            }
        }
        throw new Error();
    }

    private static Object deserializeArray(ArrayType<? extends ABIType<?>, ?> arrayType, RLPItem item) {
        ABIType<?> elementType = arrayType.getElementType();
        switch (elementType.typeCode()) {
            case 0: {
                return SuperSerial.deserializeBooleanArray((RLPList)item);
            }
            case 1: {
                return SuperSerial.deserializeByteArray(item, arrayType.isString());
            }
            case 2: {
                return SuperSerial.deserializeIntArray((RLPList)item);
            }
            case 3: {
                return SuperSerial.deserializeLongArray((RLPList)item);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return SuperSerial.deserializeObjectArray(elementType, (RLPList)item);
            }
        }
        throw new Error();
    }

    private static byte[][] serializeBooleanArray(boolean[] booleans) {
        int len = booleans.length;
        byte[][] out = new byte[len][];
        for (int i = 0; i < len; ++i) {
            out[i] = SuperSerial.serializeBoolean(booleans[i]);
        }
        return out;
    }

    private static boolean[] deserializeBooleanArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        int len = elements.size();
        boolean[] in = new boolean[len];
        for (int i = 0; i < len; ++i) {
            in[i] = elements.get(i).asBoolean();
        }
        return in;
    }

    private static byte[] serializeByteArray(Object arr, boolean isString) {
        return isString ? Strings.decode((String)arr, 1) : (byte[])arr;
    }

    private static Object deserializeByteArray(RLPItem item, boolean isString) {
        return isString ? (Object)item.asString(1) : item.asBytes();
    }

    private static byte[][] serializeIntArray(int[] ints) {
        int len = ints.length;
        byte[][] out = new byte[len][];
        for (int i = 0; i < len; ++i) {
            out[i] = Integers.toBytes(ints[i]);
        }
        return out;
    }

    private static int[] deserializeIntArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        int len = elements.size();
        int[] in = new int[len];
        for (int i = 0; i < len; ++i) {
            in[i] = elements.get(i).asInt(false);
        }
        return in;
    }

    private static byte[][] serializeLongArray(long[] longs) {
        int len = longs.length;
        byte[][] out = new byte[len][];
        for (int i = 0; i < len; ++i) {
            out[i] = Integers.toBytes(longs[i]);
        }
        return out;
    }

    private static long[] deserializeLongArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        int len = elements.size();
        long[] in = new long[len];
        for (int i = 0; i < len; ++i) {
            in[i] = elements.get(i).asLong();
        }
        return in;
    }

    private static Object[] serializeObjectArray(Object arr, ABIType<?> elementType) {
        Object[] objects = (Object[])arr;
        int len = objects.length;
        Object[] out = new Object[len];
        for (int i = 0; i < len; ++i) {
            out[i] = SuperSerial.serialize(elementType, objects[i]);
        }
        return out;
    }

    private static Object[] deserializeObjectArray(ABIType<?> elementType, RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        int len = elements.size();
        Object[] in = (Object[])Array.newInstance(elementType.clazz(), len);
        for (int i = 0; i < len; ++i) {
            in[i] = SuperSerial.deserialize(elementType, elements.get(i));
        }
        return in;
    }
}

