/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Event;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public final class ABIJSON {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    static final String FUNCTION = "function";
    static final String RECEIVE = "receive";
    static final String FALLBACK = "fallback";
    static final String CONSTRUCTOR = "constructor";
    static final String EVENT = "event";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String TUPLE = "tuple";
    private static final String COMPONENTS = "components";
    private static final String ANONYMOUS = "anonymous";
    private static final String INDEXED = "indexed";
    private static final String STATE_MUTABILITY = "stateMutability";
    private static final String PURE = "pure";
    private static final String VIEW = "view";
    static final String PAYABLE = "payable";
    private static final String CONSTANT = "constant";
    private static final Gson GSON;
    private static final Gson GSON_PRETTY;

    private ABIJSON() {
    }

    public static Function parseFunction(String objectJson) {
        return ABIJSON.parseFunction(JsonUtils.parseObject(objectJson));
    }

    public static Function parseFunction(JsonObject function) {
        return ABIJSON.parseFunction(function, Function.newDefaultDigest());
    }

    public static Function parseFunction(JsonObject function, MessageDigest messageDigest) {
        return ABIJSON._parseFunction(JsonUtils.getString(function, TYPE), function, messageDigest);
    }

    public static Event parseEvent(String objectJson) {
        return ABIJSON.parseEvent(JsonUtils.parseObject(objectJson));
    }

    public static Event parseEvent(JsonObject event) {
        String type = JsonUtils.getString(event, TYPE);
        if (ABIJSON.isEvent(type)) {
            return ABIJSON._parseEvent(event);
        }
        throw TypeEnum.unexpectedType(type);
    }

    public static ABIObject parseABIObject(JsonObject object) {
        String type = JsonUtils.getString(object, TYPE);
        return ABIJSON.isEvent(type) ? ABIJSON._parseEvent(object) : ABIJSON._parseFunction(type, object, Function.newDefaultDigest());
    }

    public static List<Function> parseFunctions(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, true, false, Function.newDefaultDigest(), Function.class);
    }

    public static List<Event> parseEvents(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, false, true, null, Event.class);
    }

    public static List<ABIObject> parseElements(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, true, true, Function.newDefaultDigest(), ABIObject.class);
    }

    private static <T extends ABIObject> List<T> parseElements(String arrayJson, boolean functions, boolean events, MessageDigest digest, Class<T> classOfT) {
        ArrayList<ABIObject> abiObjects = new ArrayList<ABIObject>();
        for (JsonElement e : JsonUtils.parseArray(arrayJson)) {
            if (!e.isJsonObject()) continue;
            JsonObject jsonObj = (JsonObject)e;
            String type = JsonUtils.getString(jsonObj, TYPE);
            if (ABIJSON.isEvent(type)) {
                if (!events) continue;
                abiObjects.add((ABIObject)classOfT.cast(ABIJSON.parseEvent(jsonObj)));
                continue;
            }
            if (!functions) continue;
            abiObjects.add((ABIObject)classOfT.cast(ABIJSON._parseFunction(type, jsonObj, digest)));
        }
        return abiObjects;
    }

    private static boolean isEvent(String typeString) {
        return EVENT.equals(typeString);
    }

    private static Function _parseFunction(String type, JsonObject function, MessageDigest digest) {
        return new Function(TypeEnum.parse(type), JsonUtils.getString(function, NAME), ABIJSON.parseTypes(JsonUtils.getArray(function, INPUTS)), ABIJSON.parseTypes(JsonUtils.getArray(function, OUTPUTS)), JsonUtils.getString(function, STATE_MUTABILITY), digest);
    }

    private static Event _parseEvent(JsonObject event) {
        JsonArray inputs = JsonUtils.getArray(event, INPUTS);
        if (inputs != null) {
            int inputsLen = inputs.size();
            ABIType[] inputsArray = new ABIType[inputsLen];
            boolean[] indexed = new boolean[inputsLen];
            for (int i = 0; i < inputsLen; ++i) {
                JsonObject inputObj = inputs.get(i).getAsJsonObject();
                inputsArray[i] = ABIJSON.parseType(inputObj);
                indexed[i] = JsonUtils.getBoolean(inputObj, INDEXED);
            }
            return new Event(JsonUtils.getString(event, NAME), JsonUtils.getBoolean(event, ANONYMOUS, false), TupleType.wrap((ABIType[])inputsArray), indexed);
        }
        throw new IllegalArgumentException("array \"inputs\" null or not found");
    }

    private static TupleType parseTypes(JsonArray array) {
        if (array != null) {
            ABIType[] elementsArray = new ABIType[array.size()];
            for (int i = 0; i < elementsArray.length; ++i) {
                elementsArray[i] = ABIJSON.parseType(array.get(i).getAsJsonObject());
            }
            return TupleType.wrap((ABIType[])elementsArray);
        }
        return TupleType.EMPTY;
    }

    private static ABIType<?> parseType(JsonObject object) {
        String typeStr = JsonUtils.getString(object, TYPE);
        if (typeStr.startsWith(TUPLE)) {
            TupleType baseType = ABIJSON.parseTypes(JsonUtils.getArray(object, COMPONENTS));
            return TypeFactory.build(baseType.canonicalType + typeStr.substring(TUPLE.length()), baseType, JsonUtils.getString(object, NAME));
        }
        return TypeFactory.create(typeStr, Object.class, JsonUtils.getString(object, NAME));
    }

    static String toJson(ABIObject x, boolean function, boolean pretty) {
        try {
            StringWriter stringOut = new StringWriter();
            JsonWriter out = (pretty ? GSON_PRETTY : GSON).newJsonWriter((Writer)stringOut);
            out.beginObject();
            if (function) {
                Function f = (Function)x;
                TypeEnum type = f.getType();
                out.name(TYPE).value(type.toString());
                if (type != TypeEnum.FALLBACK) {
                    ABIJSON.addIfValueNotNull(out, NAME, x.getName());
                    if (type != TypeEnum.RECEIVE) {
                        ABIJSON.writeJsonArray(out, INPUTS, x.getInputs(), null);
                        if (type != TypeEnum.CONSTRUCTOR) {
                            ABIJSON.writeJsonArray(out, OUTPUTS, f.getOutputs(), null);
                        }
                    }
                }
                String stateMutability = f.getStateMutability();
                ABIJSON.addIfValueNotNull(out, STATE_MUTABILITY, stateMutability);
                out.name(CONSTANT).value(VIEW.equals(stateMutability) || PURE.equals(stateMutability));
            } else {
                Event e = (Event)x;
                out.name(TYPE).value(EVENT);
                ABIJSON.addIfValueNotNull(out, NAME, x.getName());
                ABIJSON.writeJsonArray(out, INPUTS, x.getInputs(), e.getIndexManifest());
            }
            out.endObject();
            return stringOut.toString();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private static void writeJsonArray(JsonWriter out, String name, TupleType tupleType, boolean[] indexedManifest) throws IOException {
        out.name(name).beginArray();
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            ABIType<?> e = tupleType.elementTypes[i];
            out.beginObject();
            ABIJSON.addIfValueNotNull(out, NAME, e.getName());
            out.name(TYPE);
            String type = e.canonicalType;
            if (type.startsWith("(")) {
                out.value(type.replace(type.substring(0, type.lastIndexOf(41) + 1), TUPLE));
                ABIType<Object> base = e;
                while (6 == base.typeCode()) {
                    base = ((ArrayType)base).getElementType();
                }
                ABIJSON.writeJsonArray(out, COMPONENTS, (TupleType)base, null);
            } else {
                out.value(type);
            }
            if (indexedManifest != null) {
                out.name(INDEXED).value(indexedManifest[i]);
            }
            out.endObject();
        }
        out.endArray();
    }

    private static void addIfValueNotNull(JsonWriter out, String key, String value) throws IOException {
        if (value != null) {
            out.name(key).value(value);
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        GSON = builder.create();
        GSON_PRETTY = builder.setPrettyPrinting().create();
    }
}

