/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import com.esaulpaugh.headlong.util.SuperSerial;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public final class ArrayType<E extends ABIType<?>, J>
extends ABIType<J> {
    private static final ClassLoader CLASS_LOADER = ArrayType.class.getClassLoader();
    static final Class<String> STRING_CLASS = String.class;
    static final Class<String[]> STRING_ARRAY_CLASS = String[].class;
    public static final int DYNAMIC_LENGTH = -1;
    private final boolean isString;
    private final E elementType;
    private final int length;
    private final Class<?> arrayClass;

    ArrayType(String canonicalType, Class<J> clazz, E elementType, int length) {
        this(canonicalType, clazz, elementType, length, null);
    }

    ArrayType(String canonicalType, Class<J> clazz, E elementType, int length, Class<?> arrayClass) {
        super(canonicalType, clazz, length == -1 || ((ABIType)elementType).dynamic);
        this.isString = this.clazz == STRING_CLASS;
        this.elementType = elementType;
        this.length = length;
        this.arrayClass = arrayClass;
    }

    public E getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isString() {
        return this.isString;
    }

    @Override
    Class<?> arrayClass() throws ClassNotFoundException {
        return this.arrayClass != null ? this.arrayClass : Class.forName('[' + this.clazz.getName(), false, CLASS_LOADER);
    }

    @Override
    public int typeCode() {
        return 6;
    }

    @Override
    int byteLength(Object value) {
        return TupleType.totalLen(this.calcElementsLen(value), this.length == -1);
    }

    private int calcElementsLen(Object value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length * 32;
            }
            case 1: {
                return Integers.roundLengthUp(this.byteCount(value), 32);
            }
            case 2: {
                return ((int[])value).length * 32;
            }
            case 3: {
                return ((long[])value).length * 32;
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * 32;
            }
            case 6: 
            case 7: {
                return this.measureByteLength((Object[])value);
            }
        }
        throw new Error();
    }

    private int staticByteLengthPacked() {
        if (this.length == -1) {
            throw new IllegalArgumentException("array of dynamic elements");
        }
        return this.length * ((ABIType)this.elementType).byteLengthPacked(null);
    }

    @Override
    int byteLengthPacked(Object value) {
        if (value == null) {
            return this.staticByteLengthPacked();
        }
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length;
            }
            case 1: {
                return this.byteCount(value);
            }
            case 2: {
                return ((int[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 3: {
                return ((long[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 6: 
            case 7: {
                return this.measureByteLengthPacked((Object[])value);
            }
        }
        throw new Error();
    }

    private int byteCount(Object value) {
        return this.decodeIfString(value).length;
    }

    byte[] decodeIfString(Object value) {
        return !this.isString ? (byte[])value : Strings.decode((String)value, 1);
    }

    Object encodeIfString(byte[] bytes) {
        return !this.isString ? bytes : (byte[])Strings.encode(bytes, 1);
    }

    @Override
    public int validate(J value) {
        return TupleType.totalLen(this.validateElements(this.validateClass(value)), this.length == -1);
    }

    private int validateElements(J value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return this.validateBooleans((boolean[])value);
            }
            case 1: {
                return this.validateBytes(value);
            }
            case 2: {
                return this.validateInts((int[])value, (IntType)this.elementType);
            }
            case 3: {
                return this.validateLongs((long[])value, (LongType)this.elementType);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.validateObjects((Object[])value);
            }
        }
        throw new Error();
    }

    private int validateBooleans(boolean[] arr) {
        return this.checkLength(arr.length, arr) * 32;
    }

    private int validateBytes(J arr) {
        return Integers.roundLengthUp(this.checkLength(this.byteCount(arr), arr), 32);
    }

    private int offsetsLen(int len) {
        return ((ABIType)this.elementType).dynamic ? 32 * len : 0;
    }

    private int validateInts(int[] arr, IntType type) {
        return TupleType.countBytes(true, this.checkLength(arr.length, arr), this.offsetsLen(arr.length), i -> type.validatePrimitive(arr[i]));
    }

    private int validateLongs(long[] arr, LongType type) {
        return TupleType.countBytes(true, this.checkLength(arr.length, arr), this.offsetsLen(arr.length), i -> type.validatePrimitive(arr[i]));
    }

    private int validateObjects(Object[] arr) {
        return TupleType.countBytes(true, this.checkLength(arr.length, arr), this.offsetsLen(arr.length), i -> ((ABIType)this.elementType)._validate(arr[i]));
    }

    private int measureByteLength(Object[] arr) {
        return TupleType.countBytes(true, arr.length, this.offsetsLen(arr.length), i -> ((ABIType)this.elementType).byteLength(arr[i]));
    }

    private int measureByteLengthPacked(Object[] arr) {
        return TupleType.countBytes(true, arr.length, 0, i -> ((ABIType)this.elementType).byteLengthPacked(arr[i]));
    }

    private int checkLength(int valueLen, Object value) {
        if (this.length != -1 && this.length != valueLen) {
            throw this.mismatchErr("array length", ArrayType.friendlyClassName(value.getClass(), valueLen), ArrayType.friendlyClassName(this.clazz, this.length), "length " + this.length, "" + valueLen);
        }
        return valueLen;
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                this.encodeBooleans((boolean[])value, dest);
                return;
            }
            case 1: {
                this.encodeBytes(this.decodeIfString(value), dest);
                return;
            }
            case 2: {
                this.encodeInts((int[])value, dest);
                return;
            }
            case 3: {
                this.encodeLongs((long[])value, dest);
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Object[] arr = (Object[])value;
                this.encodeArrayLen(arr.length, dest);
                TupleType.encodeObjects(this.dynamic, arr, i -> this.elementType, dest);
                return;
            }
        }
        throw new Error();
    }

    private void encodeArrayLen(int len, ByteBuffer dest) {
        if (this.length == -1) {
            Encoding.insertInt(len, dest);
        }
    }

    private void encodeBooleans(boolean[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (boolean e : arr) {
            BooleanType.encodeBoolean(e, dest);
        }
    }

    private void encodeBytes(byte[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        Encoding.insertBytesPadded(arr, dest);
    }

    private void encodeInts(int[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (int e : arr) {
            Encoding.insertInt(e, dest);
        }
    }

    private void encodeLongs(long[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (long e : arr) {
            Encoding.insertInt(e, dest);
        }
    }

    @Override
    J decode(ByteBuffer bb, byte[] unitBuffer) {
        int arrayLen = this.length == -1 ? Encoding.UINT17.decode(bb, unitBuffer) : this.length;
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return (J)ArrayType.decodeBooleans(arrayLen, bb, unitBuffer);
            }
            case 1: {
                return (J)this.decodeBytes(arrayLen, bb);
            }
            case 2: {
                return (J)ArrayType.decodeInts(arrayLen, bb, (IntType)this.elementType, unitBuffer);
            }
            case 3: {
                return (J)ArrayType.decodeLongs(arrayLen, bb, (LongType)this.elementType, unitBuffer);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (J)this.decodeObjects(arrayLen, bb, unitBuffer);
            }
        }
        throw new Error();
    }

    private static Object decodeBooleans(int len, ByteBuffer bb, byte[] unitBuffer) {
        boolean[] booleans = new boolean[len];
        int booleanOffset = 31;
        for (int i = 0; i < len; ++i) {
            bb.get(unitBuffer);
            for (int j = 0; j < 31; ++j) {
                if (unitBuffer[j] == 0) continue;
                throw new IllegalArgumentException("illegal boolean value @ " + (bb.position() - 32));
            }
            byte last = unitBuffer[31];
            if (last == 1) {
                booleans[i] = true;
                continue;
            }
            if (last == 0) continue;
            throw new IllegalArgumentException("illegal boolean value @ " + (bb.position() - 32));
        }
        return booleans;
    }

    private Object decodeBytes(int len, ByteBuffer bb) {
        byte[] data = new byte[len];
        bb.get(data);
        int mod = Integers.mod(len, 32);
        if (mod != 0) {
            byte[] padding = new byte[32 - mod];
            bb.get(padding);
            for (byte b : padding) {
                if (b == 0) continue;
                throw new IllegalArgumentException("malformed array: non-zero padding byte");
            }
        }
        return this.encodeIfString(data);
    }

    private static Object decodeInts(int len, ByteBuffer bb, IntType intType, byte[] unitBuffer) {
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            ints[i] = intType.decode(bb, unitBuffer);
        }
        return ints;
    }

    private static Object decodeLongs(int len, ByteBuffer bb, LongType longType, byte[] unitBuffer) {
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = longType.decode(bb, unitBuffer);
        }
        return longs;
    }

    private Object decodeObjects(int len, ByteBuffer bb, byte[] unitBuffer) {
        Object[] elements = (Object[])Array.newInstance(((ABIType)this.elementType).clazz, len);
        TupleType.decodeObjects(bb, unitBuffer, i -> this.elementType, elements);
        return elements;
    }

    @Override
    public J parseArgument(String s) {
        return (J)SuperSerial.deserializeArray(this, s, false, this.clazz);
    }
}

