/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class BooleanType
extends UnitType<Boolean> {
    private static final byte[] BOOLEAN_FALSE = new byte[32];
    private static final byte[] BOOLEAN_TRUE = new byte[32];

    BooleanType() {
        super("bool", Boolean.class, 1, true);
    }

    @Override
    Class<?> arrayClass() {
        return boolean[].class;
    }

    @Override
    public int typeCode() {
        return 0;
    }

    @Override
    int byteLengthPacked(Object value) {
        return 1;
    }

    @Override
    public int validate(Boolean value) {
        return 32;
    }

    @Override
    int encodeHead(Object value, ByteBuffer dest, int offset) {
        BooleanType.encodeBoolean((Boolean)value, dest);
        return offset;
    }

    @Override
    Boolean decode(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return BooleanType.decodeBoolean(bi.byteValue());
    }

    static void encodeBoolean(boolean val, ByteBuffer dest) {
        dest.put(val ? BOOLEAN_TRUE : BOOLEAN_FALSE);
    }

    static Boolean decodeBoolean(byte b) {
        switch (b) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException("illegal boolean value: " + b);
    }

    @Override
    public Boolean parseArgument(String s) {
        return Boolean.parseBoolean(s);
    }

    static {
        BooleanType.BOOLEAN_TRUE[BooleanType.BOOLEAN_TRUE.length - 1] = 1;
    }
}

