/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;

public final class Event
implements ABIObject {
    private final String name;
    private final boolean anonymous;
    private final TupleType inputs;
    private final boolean[] indexManifest;

    public static Event create(String name, TupleType inputs, boolean ... indexed) {
        return new Event(name, false, inputs, indexed);
    }

    public static Event createAnonymous(String name, TupleType inputs, boolean ... indexed) {
        return new Event(name, true, inputs, indexed);
    }

    public Event(String name, boolean anonymous, TupleType inputs, boolean ... indexed) {
        this.name = Objects.requireNonNull(name);
        this.inputs = Objects.requireNonNull(inputs);
        if (indexed.length != inputs.elementTypes.length) {
            throw new IllegalArgumentException("indexed.length doesn't match number of inputs");
        }
        this.indexManifest = Arrays.copyOf(indexed, indexed.length);
        this.anonymous = anonymous;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TupleType getInputs() {
        return this.inputs;
    }

    public boolean[] getIndexManifest() {
        return Arrays.copyOf(this.indexManifest, this.indexManifest.length);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name + this.inputs.canonicalType;
    }

    public TupleType getIndexedParams() {
        return this.inputs.subTupleType(this.indexManifest);
    }

    public TupleType getNonIndexedParams() {
        return this.inputs.subTupleTypeNegative(this.indexManifest);
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.name.hashCode() + this.inputs.hashCode()) + Arrays.hashCode(this.indexManifest)) + Boolean.hashCode(this.anonymous);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        return other.anonymous == this.anonymous && other.name.equals(this.name) && other.inputs.equals(this.inputs) && Arrays.equals(other.indexManifest, this.indexManifest);
    }

    public static Event fromJson(String eventJson) {
        return Event.fromJsonObject(JsonUtils.parseObject(eventJson));
    }

    public static Event fromJsonObject(JsonObject event) {
        return ABIJSON.parseEvent(event);
    }

    @Override
    public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, false, pretty);
    }

    public String toString() {
        return this.toJson(true);
    }
}

