/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.JsonUtils;
import com.esaulpaugh.headlong.util.Strings;
import com.google.gson.JsonObject;
import com.joemelsha.crypto.hash.Keccak;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Function
implements ABIObject {
    private static final Pattern ALL_ASCII_NO_OPEN_PAREN = Pattern.compile("^[[^(]&&\\p{ASCII}]*$");
    private static final Pattern OPEN_PAREN_OR_NON_ASCII = Pattern.compile("[([^\\p{ASCII}]]");
    public static final int SELECTOR_LEN = 4;
    private final TypeEnum type;
    private final String name;
    private final TupleType inputTypes;
    private final TupleType outputTypes;
    private final String stateMutability;
    private final byte[] selector = new byte[4];
    private final String hashAlgorithm;

    public Function(String signature) {
        this(signature, null);
    }

    public Function(String signature, String outputs) {
        this(TypeEnum.FUNCTION, signature.substring(0, signature.indexOf(40)), TupleType.parse(signature.substring(signature.indexOf(40))), outputs != null ? TupleType.parse(outputs) : TupleType.EMPTY, null, Function.newDefaultDigest());
    }

    public Function(TypeEnum type, String name, TupleType inputs, TupleType outputs, String stateMutability, MessageDigest messageDigest) {
        this.type = Objects.requireNonNull(type);
        this.name = name != null ? Function.validateName(name) : null;
        this.inputTypes = Objects.requireNonNull(inputs);
        this.outputTypes = Objects.requireNonNull(outputs);
        this.stateMutability = stateMutability;
        this.hashAlgorithm = Objects.requireNonNull(messageDigest.getAlgorithm());
        this.validateFunction();
        this.generateSelector(messageDigest);
    }

    public TypeEnum getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TupleType getInputs() {
        return this.inputTypes;
    }

    public TupleType getOutputs() {
        return this.outputTypes;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public byte[] selector() {
        return Arrays.copyOf(this.selector, this.selector.length);
    }

    public String selectorHex() {
        return Strings.encode(this.selector);
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name != null ? this.name + this.inputTypes.canonicalType : this.inputTypes.canonicalType;
    }

    private void validateFunction() {
        switch (this.type.name) {
            case "function": {
                if (this.name == null) {
                    throw this.validationErr("define name");
                }
                return;
            }
            case "receive": {
                if (!"receive".equals(this.name)) {
                    throw this.validationErr("define name as \"receive\"");
                }
                if (!"payable".equals(this.stateMutability)) {
                    throw this.validationErr("define stateMutability as \"payable\"");
                }
            }
            case "fallback": {
                if (this.inputTypes.elementTypes.length > 0) {
                    throw this.validationErr("define no inputs");
                }
            }
            case "constructor": {
                if (this.outputTypes.elementTypes.length > 0) {
                    throw this.validationErr("define no outputs");
                }
                if (this.type != TypeEnum.RECEIVE && this.name != null) {
                    throw this.validationErr("not define name");
                }
                return;
            }
            case "event": {
                throw TypeEnum.unexpectedType(this.type.toString());
            }
        }
        throw new Error();
    }

    private IllegalArgumentException validationErr(String typeRuleStr) {
        return new IllegalArgumentException("type is \"" + (Object)((Object)this.type) + "\"; functions of this type must " + typeRuleStr);
    }

    private void generateSelector(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(Strings.decode(this.getCanonicalSignature(), 3));
        try {
            messageDigest.digest(this.selector, 0, 4);
        }
        catch (DigestException de) {
            throw new Error(de);
        }
    }

    private int validatedCallLength(Tuple args) {
        return 4 + this.inputTypes.validate(args);
    }

    public int measureCallLength(Tuple args) {
        return this.validatedCallLength(args);
    }

    public ByteBuffer encodeCallWithArgs(Object ... args) {
        return this.encodeCall(new Tuple(args));
    }

    public ByteBuffer encodeCall(Tuple args) {
        ByteBuffer dest = ByteBuffer.wrap(new byte[this.validatedCallLength(args)]);
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
        return dest;
    }

    public Function encodeCall(Tuple args, ByteBuffer dest) {
        this.inputTypes.validate(args);
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
        return this;
    }

    public Tuple decodeCall(byte[] array) {
        return this.decodeCall(ByteBuffer.wrap(array));
    }

    public Tuple decodeCall(ByteBuffer abiBuffer) {
        byte[] unitBuffer = ABIType.newUnitBuffer();
        abiBuffer.get(unitBuffer, 0, 4);
        for (int i = 0; i < 4; ++i) {
            if (unitBuffer[i] == this.selector[i]) continue;
            throw new IllegalArgumentException("given selector does not match: expected: " + this.selectorHex() + ", found: " + Strings.encode(unitBuffer, 0, 4, 0));
        }
        return this.inputTypes.decode(abiBuffer, unitBuffer);
    }

    public Tuple decodeReturn(byte[] returnVals) {
        return (Tuple)this.outputTypes.decode(returnVals);
    }

    public Tuple decodeReturn(ByteBuffer returnVals) {
        return (Tuple)this.outputTypes.decode(returnVals);
    }

    public <J> J decodeSingletonReturn(byte[] singleton) {
        return (J)this.outputTypes.get(0).decode(singleton);
    }

    public int hashCode() {
        return 31 * Objects.hash(new Object[]{this.type, this.name, this.inputTypes, this.outputTypes, this.hashAlgorithm, this.stateMutability}) + Arrays.hashCode(this.selector);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        return other.type == this.type && Objects.equals(other.name, this.name) && other.inputTypes.equals(this.inputTypes) && other.outputTypes.equals(this.outputTypes) && Arrays.equals(other.selector, this.selector) && other.hashAlgorithm.equals(this.hashAlgorithm) && Objects.equals(other.stateMutability, this.stateMutability);
    }

    public String toString() {
        return this.toJson(true);
    }

    @Override
    public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, true, pretty);
    }

    private static String validateName(String input) {
        if (ALL_ASCII_NO_OPEN_PAREN.matcher(input).matches()) {
            return input;
        }
        Matcher badChar = OPEN_PAREN_OR_NON_ASCII.matcher(input);
        if (badChar.find()) {
            int idx = badChar.start();
            char c = input.charAt(idx);
            throw new IllegalArgumentException("illegal char 0x" + Integer.toHexString(c) + " '" + c + "' @ index " + idx);
        }
        throw new Error("regex mismatch");
    }

    public static Function parse(String signature) {
        return new Function(signature);
    }

    public static Function parse(String signature, String outputs) {
        return new Function(signature, outputs);
    }

    public static Function fromJson(String objectJson) {
        return Function.fromJsonObject(JsonUtils.parseObject(objectJson));
    }

    public static Function fromJsonObject(JsonObject function) {
        return ABIJSON.parseFunction(function);
    }

    public static MessageDigest newDefaultDigest() {
        return new Keccak(256);
    }

    public static String formatCall(byte[] abiCall) {
        return Function.formatCall(abiCall, 0, abiCall.length);
    }

    public static String formatCall(byte[] buffer, int offset, int length) {
        return Function.formatCall(buffer, offset, length, row -> TupleType.pad(0, "" + row));
    }

    public static String formatCall(byte[] buffer, int offset, int length, IntFunction<String> labeler) {
        Integers.checkIsMultiple(length - 4, 32);
        StringBuilder sb = new StringBuilder(TupleType.pad(0, "ID")).append(Strings.encode(buffer, offset, 4, 0));
        return ABIType.finishFormat(buffer, offset + 4, offset + length, labeler, sb);
    }
}

