/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.SuperSerial;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;

public final class TupleType
extends ABIType<Tuple>
implements Iterable<ABIType<?>> {
    private static final String EMPTY_TUPLE_STRING = "()";
    public static final TupleType EMPTY = new TupleType("()", false, EMPTY_TYPE_ARRAY);
    final ABIType<?>[] elementTypes;

    private TupleType(String canonicalType, boolean dynamic, ABIType<?>[] elementTypes) {
        super(canonicalType, Tuple.class, dynamic);
        this.elementTypes = elementTypes;
    }

    static <E extends ABIType<?>> TupleType wrap(E[] elements) {
        StringBuilder canonicalBuilder = new StringBuilder("(");
        boolean dynamic = false;
        for (E e : elements) {
            canonicalBuilder.append(((ABIType)e).canonicalType).append(',');
            dynamic |= ((ABIType)e).dynamic;
        }
        return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, (ABIType<?>[])elements);
    }

    public int size() {
        return this.elementTypes.length;
    }

    public ABIType<?> get(int index) {
        return this.elementTypes[index];
    }

    public ABIType<?>[] elements() {
        return Arrays.copyOf(this.elementTypes, this.elementTypes.length);
    }

    @Override
    Class<?> arrayClass() {
        return Tuple[].class;
    }

    @Override
    public int typeCode() {
        return 7;
    }

    @Override
    int byteLength(Object value) {
        Object[] elements = ((Tuple)value).elements;
        return TupleType.countBytes(false, this.elementTypes.length, 0, i -> this.measureObject(this.elementTypes[i], elements[i]));
    }

    private int measureObject(ABIType<?> type, Object value) {
        return TupleType.totalLen(type.byteLength(value), type.dynamic);
    }

    @Override
    public int byteLengthPacked(Object value) {
        Object[] elements = value != null ? ((Tuple)value).elements : new Object[this.elementTypes.length];
        return TupleType.countBytes(false, this.elementTypes.length, 0, i -> this.elementTypes[i].byteLengthPacked(elements[i]));
    }

    static int countBytes(boolean array, int len, int count, IntUnaryOperator counter) {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                count += counter.applyAsInt(i);
            }
            return count;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException((array ? "array" : "tuple") + " index " + i + ": " + iae.getMessage());
        }
    }

    @Override
    public int validate(Tuple value) {
        if (value.elements.length == this.elementTypes.length) {
            return TupleType.countBytes(false, this.elementTypes.length, 0, i -> this.validateObject(this.elementTypes[i], value.elements[i]));
        }
        throw new IllegalArgumentException("tuple length mismatch: actual != expected: " + value.elements.length + " != " + this.elementTypes.length);
    }

    private int validateObject(ABIType<?> type, Object value) {
        try {
            return TupleType.totalLen(type._validate(value), type.dynamic);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("null", npe);
        }
    }

    static int totalLen(int byteLen, boolean addUnit) {
        return addUnit ? 32 + byteLen : byteLen;
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        TupleType.encodeObjects(this.dynamic, ((Tuple)value).elements, i -> this.elementTypes[i], dest);
    }

    static void encodeObjects(boolean dynamic, Object[] values, IntFunction<ABIType<?>> getType, ByteBuffer dest) {
        int i;
        int nextOffset = !dynamic ? 0 : TupleType.headLength(values, getType);
        for (i = 0; i < values.length; ++i) {
            nextOffset = getType.apply(i).encodeHead(values[i], dest, nextOffset);
        }
        for (i = 0; i < values.length; ++i) {
            ABIType<?> t = getType.apply(i);
            if (!t.dynamic) continue;
            t.encodeTail(values[i], dest);
        }
    }

    private static int headLength(Object[] elements, IntFunction<ABIType<?>> getType) {
        int sum = 0;
        for (int i = 0; i < elements.length; ++i) {
            ABIType<?> type = getType.apply(i);
            sum += !type.dynamic ? type.byteLength(elements[i]) : 32;
        }
        return sum;
    }

    @Override
    Tuple decode(ByteBuffer bb, byte[] unitBuffer) {
        Object[] elements = new Object[this.elementTypes.length];
        TupleType.decodeObjects(bb, unitBuffer, i -> this.elementTypes[i], elements);
        return new Tuple(elements);
    }

    static void decodeObjects(ByteBuffer bb, byte[] unitBuffer, IntFunction<ABIType<?>> getType, Object[] objects) {
        int i;
        int start = bb.position();
        int[] offsets = new int[objects.length];
        for (i = 0; i < objects.length; ++i) {
            ABIType<?> t = getType.apply(i);
            if (!t.dynamic) {
                objects[i] = t.decode(bb, unitBuffer);
                continue;
            }
            offsets[i] = Encoding.UINT31.decode(bb, unitBuffer);
        }
        for (i = 0; i < objects.length; ++i) {
            int offset = offsets[i];
            if (offset <= 0) continue;
            int jump = start + offset;
            int pos = bb.position();
            if (jump != pos) {
                if (jump < pos) {
                    throw new IllegalArgumentException("illegal backwards jump: (" + start + "+" + offset + "=" + jump + ")<" + pos);
                }
                bb.position(jump);
            }
            objects[i] = getType.apply(i).decode(bb, unitBuffer);
        }
    }

    @Override
    public Tuple parseArgument(String s) {
        return SuperSerial.deserialize(this, s, false);
    }

    public ByteBuffer encodeElements(Object ... elements) {
        return this.encode(new Tuple(elements));
    }

    @Override
    public Iterator<ABIType<?>> iterator() {
        return new Iter();
    }

    public TupleType subTupleType(boolean ... manifest) {
        return this.subTupleType(manifest, false);
    }

    public TupleType subTupleTypeNegative(boolean ... manifest) {
        return this.subTupleType(manifest, true);
    }

    private TupleType subTupleType(boolean[] manifest, boolean negate) {
        if (manifest.length == this.elementTypes.length) {
            StringBuilder canonicalBuilder = new StringBuilder("(");
            boolean dynamic = false;
            ArrayList selected = new ArrayList(manifest.length);
            for (int i = 0; i < manifest.length; ++i) {
                if (!(negate ^ manifest[i])) continue;
                ABIType<?> e = this.elementTypes[i];
                canonicalBuilder.append(e.canonicalType).append(',');
                dynamic |= e.dynamic;
                selected.add(e);
            }
            return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, selected.toArray(EMPTY_TYPE_ARRAY));
        }
        throw new IllegalArgumentException("manifest.length != elementTypes.length: " + manifest.length + " != " + this.elementTypes.length);
    }

    static String completeTupleTypeString(StringBuilder sb) {
        int len = sb.length();
        return len != 1 ? sb.deleteCharAt(len - 1).append(')').toString() : EMPTY_TUPLE_STRING;
    }

    public static TupleType parse(String rawTupleTypeString) {
        return TypeFactory.createType(rawTupleTypeString, TupleType.class);
    }

    public static TupleType of(String ... typeStrings) {
        StringBuilder sb = new StringBuilder("(");
        for (String str : typeStrings) {
            sb.append(str).append(',');
        }
        return TupleType.parse(TupleType.completeTupleTypeString(sb));
    }

    public static TupleType parseElements(String rawElementsString) {
        return TupleType.parse('(' + rawElementsString + ')');
    }

    private class Iter
    implements Iterator<ABIType<?>> {
        private int index;

        Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TupleType.this.elementTypes.length;
        }

        @Override
        public ABIType<?> next() {
            try {
                return TupleType.this.elementTypes[this.index++];
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new NoSuchElementException();
            }
        }
    }
}

