/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

public enum TypeEnum {
    EVENT("event"),
    FUNCTION("function"),
    RECEIVE("receive"),
    FALLBACK("fallback"),
    CONSTRUCTOR("constructor");

    final String name;

    private TypeEnum(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static TypeEnum parse(String typeString) {
        for (TypeEnum e : TypeEnum.values()) {
            if (!e.name.equals(typeString)) continue;
            return e;
        }
        if (typeString == null) {
            return FUNCTION;
        }
        throw TypeEnum.unexpectedType(typeString);
    }

    static IllegalArgumentException unexpectedType(String t) {
        return new IllegalArgumentException("unexpected type: " + (t == null ? null : "\"" + t + "\""));
    }
}

