/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.Integers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class TypeFactory {
    private static final int ADDRESS_BIT_LEN = 160;
    private static final int DECIMAL_BIT_LEN = 128;
    private static final int DECIMAL_SCALE = 10;
    private static final int FIXED_BIT_LEN = 128;
    private static final int FIXED_SCALE = 18;
    private static final int FUNCTION_BYTE_LEN = 24;
    static final Map<String, Supplier<ABIType<?>>> SUPPLIER_MAP;
    static final String EMPTY_PARAMETER = "empty parameter";

    private TypeFactory() {
    }

    private static void mapInt(Map<String, Supplier<ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, () -> new IntType(type, bitLen, unsigned));
    }

    private static void mapLong(Map<String, Supplier<ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, () -> new LongType(type, bitLen, unsigned));
    }

    private static void mapBigInteger(Map<String, Supplier<ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, () -> new BigIntegerType(type, bitLen, unsigned));
    }

    private static void mapByteArray(Map<String, Supplier<ABIType<?>>> map, String type, int arrayLen) {
        map.put(type, () -> new ArrayType<ByteType, byte[]>(type, byte[].class, ByteType.SIGNED, arrayLen, byte[][].class));
    }

    public static <T extends ABIType<?>> T createType(String rawType, Class<T> classOfT) {
        return (T)((ABIType)classOfT.cast(TypeFactory.build(rawType, null, null)));
    }

    public static <J> ABIType<J> create(String rawType, Class<J> classOfJ) {
        return TypeFactory.create(rawType, classOfJ, null);
    }

    public static <J> ABIType<J> create(String rawType, Class<J> classOfJ, String name) {
        return TypeFactory.build(rawType, null, name);
    }

    public static ABIType<?> create(String rawType) {
        return TypeFactory.build(rawType, null, null);
    }

    static ABIType<?> build(String rawType, TupleType baseType, String name) {
        return TypeFactory._build(rawType, baseType).setName(name);
    }

    private static ABIType<?> _build(String rawType, ABIType<?> baseType) {
        try {
            int lastCharIdx = rawType.length() - 1;
            if (rawType.charAt(lastCharIdx) == ']') {
                int secondToLastCharIdx = lastCharIdx - 1;
                int arrayOpenIndex = rawType.lastIndexOf(91, secondToLastCharIdx);
                ABIType<?> elementType = TypeFactory._build(rawType.substring(0, arrayOpenIndex), baseType);
                String type = elementType.canonicalType + rawType.substring(arrayOpenIndex);
                int length = arrayOpenIndex == secondToLastCharIdx ? -1 : TypeFactory.parseLen(rawType.substring(arrayOpenIndex + 1, lastCharIdx));
                return new ArrayType(type, elementType.arrayClass(), elementType, length);
            }
            if (baseType != null || (baseType = TypeFactory.resolveBaseType(rawType)) != null) {
                return baseType;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new Error(cnfe);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException("unrecognized type: \"" + rawType + '\"');
    }

    private static int parseLen(String lenStr) {
        try {
            int length;
            if ((TypeFactory.leadDigitValid(lenStr.charAt(0)) || lenStr.equals("0")) && (length = Integer.parseInt(lenStr)) >= 0) {
                return length;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("bad array length");
    }

    private static ABIType<?> resolveBaseType(String baseTypeStr) {
        if (baseTypeStr.charAt(0) == '(') {
            return TypeFactory.parseTupleType(baseTypeStr);
        }
        Supplier<ABIType<?>> supplier = SUPPLIER_MAP.get(baseTypeStr);
        return supplier != null ? supplier.get() : TypeFactory.tryParseFixed(baseTypeStr);
    }

    private static BigDecimalType tryParseFixed(String type) {
        int idx = type.indexOf("fixed");
        boolean unsigned = false;
        if (idx == 0 || (unsigned = idx == 1 && type.charAt(0) == 'u')) {
            int indexOfX = type.lastIndexOf(120);
            try {
                String mStr = type.substring(idx + "fixed".length(), indexOfX);
                String nStr = type.substring(indexOfX + 1);
                if (TypeFactory.leadDigitValid(mStr.charAt(0)) && TypeFactory.leadDigitValid(nStr.charAt(0))) {
                    int M = Integer.parseInt(mStr);
                    int N = Integer.parseInt(nStr);
                    if (Integers.mod(M, 8) == 0 && M >= 8 && M <= 256 && N > 0 && N <= 80) {
                        return new BigDecimalType((unsigned ? "ufixed" : "fixed") + M + 'x' + N, M, N, unsigned);
                    }
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean leadDigitValid(char c) {
        return c > '0' && c <= '9';
    }

    private static TupleType parseTupleType(String rawTypeStr) {
        ArrayList elements = new ArrayList();
        try {
            int argStart = 1;
            int argEnd = 1;
            int prevTerminator = 41;
            int last = rawTypeStr.length() - 1;
            block7: while (argStart <= last) {
                switch (rawTypeStr.charAt(argStart)) {
                    case '(': {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, TypeFactory.findSubtupleEnd(rawTypeStr, argStart));
                        break;
                    }
                    case ')': {
                        if (prevTerminator != 44) break block7;
                        throw new IllegalArgumentException(EMPTY_PARAMETER);
                    }
                    case ',': {
                        if (rawTypeStr.charAt(argEnd) == ')') break block7;
                        throw new IllegalArgumentException(EMPTY_PARAMETER);
                    }
                    default: {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, argStart);
                    }
                }
                elements.add(TypeFactory._build(rawTypeStr.substring(argStart, argEnd), null));
                char c = rawTypeStr.charAt(argEnd);
                prevTerminator = c;
                if (c != ',') break;
                argStart = argEnd + 1;
            }
            if (argEnd == last && prevTerminator == 41) {
                return TupleType.wrap((ABIType[])elements.toArray(ABIType.EMPTY_TYPE_ARRAY));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("@ index " + elements.size() + ", " + iae.getMessage(), iae);
        }
        return null;
    }

    private static int findSubtupleEnd(String parentTypeString, int i) {
        int depth = 1;
        do {
            char x;
            if ((x = parentTypeString.charAt(++i)) > ')') continue;
            if (x == ')') {
                --depth;
                continue;
            }
            if (x != '(') continue;
            ++depth;
        } while (depth > 0);
        return i + 1;
    }

    private static int nextTerminator(String signature, int i) {
        int len = signature.length();
        while (i < len) {
            char c = signature.charAt(i);
            if (c == ',' || c == ')') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static {
        int n;
        HashMap lambdaMap = new HashMap(256);
        for (n = 8; n <= 32; n += 8) {
            TypeFactory.mapInt(lambdaMap, "int" + n, n, false);
        }
        for (n = 40; n <= 64; n += 8) {
            TypeFactory.mapLong(lambdaMap, "int" + n, n, false);
        }
        for (n = 72; n <= 256; n += 8) {
            TypeFactory.mapBigInteger(lambdaMap, "int" + n, n, false);
        }
        for (n = 8; n <= 24; n += 8) {
            TypeFactory.mapInt(lambdaMap, "uint" + n, n, true);
        }
        for (n = 32; n <= 56; n += 8) {
            TypeFactory.mapLong(lambdaMap, "uint" + n, n, true);
        }
        for (n = 64; n <= 256; n += 8) {
            TypeFactory.mapBigInteger(lambdaMap, "uint" + n, n, true);
        }
        for (n = 1; n <= 32; ++n) {
            TypeFactory.mapByteArray(lambdaMap, "bytes" + n, n);
        }
        TypeFactory.mapBigInteger(lambdaMap, "address", 160, true);
        TypeFactory.mapByteArray(lambdaMap, "function", 24);
        TypeFactory.mapByteArray(lambdaMap, "bytes", -1);
        lambdaMap.put("string", () -> new ArrayType<ByteType, String>("string", ArrayType.STRING_CLASS, ByteType.SIGNED, -1, ArrayType.STRING_ARRAY_CLASS));
        lambdaMap.put("fixed128x18", () -> new BigDecimalType("fixed128x18", 128, 18, false));
        lambdaMap.put("ufixed128x18", () -> new BigDecimalType("ufixed128x18", 128, 18, true));
        lambdaMap.put("decimal", () -> new BigDecimalType("decimal", 128, 10, false));
        lambdaMap.put("int", (Supplier)lambdaMap.get("int256"));
        lambdaMap.put("uint", (Supplier)lambdaMap.get("uint256"));
        lambdaMap.put("fixed", (Supplier)lambdaMap.get("fixed128x18"));
        lambdaMap.put("ufixed", (Supplier)lambdaMap.get("ufixed128x18"));
        lambdaMap.put("bool", BooleanType::new);
        SUPPLIER_MAP = Collections.unmodifiableMap(lambdaMap);
    }
}

