/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPStream;
import com.esaulpaugh.headlong.rlp.RLPStreamIterator;
import com.esaulpaugh.headlong.rlp.RLPString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;

public final class RLPDecoder {
    public static final RLPDecoder RLP_STRICT = new RLPDecoder(false);
    public static final RLPDecoder RLP_LENIENT = new RLPDecoder(true);
    public final boolean lenient;

    private RLPDecoder(boolean lenient) {
        this.lenient = lenient;
    }

    public Iterator<RLPItem> sequenceIterator(byte[] buffer) {
        return this.sequenceIterator(buffer, 0);
    }

    public Iterator<RLPItem> sequenceIterator(byte[] buffer, int index) {
        return new SeqIter(this, buffer, index);
    }

    public RLPStream stream(byte[] bytes) {
        return this.stream(new ByteArrayInputStream(bytes));
    }

    public RLPStream stream(InputStream is) {
        return new RLPStream(is, this);
    }

    public Iterator<RLPItem> listIterator(byte[] buffer) {
        return this.listIterator(buffer, 0);
    }

    public Iterator<RLPItem> listIterator(byte[] buffer, int index) {
        return this.wrapList(buffer, index).iterator(this);
    }

    public RLPString wrapString(byte lengthOneRlp) {
        return this.wrapString(new byte[]{lengthOneRlp}, 0);
    }

    public RLPString wrapString(byte[] encoding) {
        return this.wrapString(encoding, 0);
    }

    public RLPString wrapString(byte[] buffer, int index) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return new RLPString(lead, type, buffer, index, Integer.MAX_VALUE, this.lenient);
            }
        }
        throw new IllegalArgumentException("item is not a string");
    }

    public RLPList wrapList(byte[] encoding) {
        return this.wrapList(encoding, 0);
    }

    public RLPList wrapList(byte[] buffer, int index) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 3: 
            case 4: {
                return new RLPList(lead, type, buffer, index, Integer.MAX_VALUE, this.lenient);
            }
        }
        throw new IllegalArgumentException("item is not a list");
    }

    public RLPItem wrap(byte lengthOneRLP) {
        return this.wrap(new byte[]{lengthOneRLP}, 0);
    }

    public RLPItem wrap(byte[] encoding) {
        return this.wrap(encoding, 0);
    }

    public RLPItem wrap(byte[] buffer, int index) {
        return this.wrap(buffer, index, Integer.MAX_VALUE);
    }

    RLPItem wrap(byte[] buffer, int index, int containerEnd) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return new RLPString(lead, type, buffer, index, containerEnd, this.lenient);
            }
            case 3: 
            case 4: {
                return new RLPList(lead, type, buffer, index, containerEnd, this.lenient);
            }
        }
        throw new Error();
    }

    public List<RLPItem> collectAll(byte[] encodings) {
        return this.collectAll(encodings, 0);
    }

    public List<RLPItem> collectAll(byte[] encodings, int index) {
        return this.collectBefore(encodings, index, encodings.length);
    }

    public List<RLPItem> collectBefore(byte[] encodings, int endIndex) {
        return this.collectBefore(encodings, 0, endIndex);
    }

    public List<RLPItem> collectBefore(byte[] encodings, int index, int endIndex) {
        ArrayList<RLPItem> dest = new ArrayList<RLPItem>();
        this.collectBefore(encodings, index, endIndex, dest);
        return dest;
    }

    public List<RLPItem> collectN(byte[] encodings, int n) {
        return this.collectN(encodings, 0, n);
    }

    public List<RLPItem> collectN(byte[] encodings, int index, int n) {
        ArrayList<RLPItem> dest = new ArrayList<RLPItem>(n);
        this.collect(encodings, index, (count, idx) -> count < n, dest);
        return dest;
    }

    public int collectAll(byte[] encodings, int index, Collection<RLPItem> dest) {
        return this.collectBefore(encodings, index, encodings.length, dest);
    }

    public int collectBefore(byte[] encodings, int index, int endIndex, Collection<RLPItem> dest) {
        return this.collect(encodings, index, (count, idx) -> idx < endIndex, dest);
    }

    public void collectN(byte[] encodings, int index, int n, Collection<RLPItem> dest) {
        this.collect(encodings, index, (count, idx) -> count < n, dest);
    }

    public int collect(byte[] encodings, int index, BiPredicate<Integer, Integer> predicate, Collection<RLPItem> collection) {
        int count = 0;
        while (predicate.test(count, index)) {
            RLPItem item = this.wrap(encodings, index);
            collection.add(item);
            ++count;
            index = item.endIndex;
        }
        return count;
    }

    private static final class SeqIter
    extends RLPStreamIterator {
        SeqIter(RLPDecoder decoder, byte[] buffer, int index) {
            super(null, decoder, buffer, index);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.index < this.buffer.length) {
                this.next = this.decoder.wrap(this.buffer, this.index);
                this.index = this.next.endIndex;
                return true;
            }
            return false;
        }
    }
}

