/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.KVP;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.util.Integers;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public final class RLPEncoder {
    private RLPEncoder() {
    }

    static int payloadLen(long seq, List<KVP> pairs) {
        long sum = RLPEncoder.stringEncodedLen(Integers.toBytes(seq));
        for (KVP pair : pairs) {
            sum += (long)pair.length;
        }
        return RLPEncoder.requireNoOverflow(sum);
    }

    static int itemLen(int dataLen) {
        return (RLPEncoder.isShort(dataLen) ? 1 : 1 + Integers.len(dataLen)) + dataLen;
    }

    static void insertListPrefix(int dataLen, ByteBuffer bb) {
        if (RLPEncoder.isShort(dataLen)) {
            bb.put((byte)(-64 + dataLen));
        } else {
            bb.put((byte)(-9 + Integers.len(dataLen)));
            Integers.putLong(dataLen, bb);
        }
    }

    static byte[] encodeRecordContent(int dataLen, long seq, List<KVP> pairs) {
        pairs.sort(KVP.PAIR_COMPARATOR);
        byte[] arr = new byte[RLPEncoder.itemLen(dataLen)];
        ByteBuffer bb = ByteBuffer.wrap(arr);
        RLPEncoder.insertListPrefix(dataLen, bb);
        RLPEncoder.encodeString(Integers.toBytes(seq), bb);
        for (KVP pair : pairs) {
            pair.export(bb);
        }
        return arr;
    }

    private static int requireNoOverflow(long val) {
        if (val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        throw new ArithmeticException("integer overflow");
    }

    private static boolean isShort(int dataLen) {
        return dataLen < 56;
    }

    private static int sumEncodedLen(Iterable<?> rawItems) {
        long sum = 0L;
        for (Object raw : rawItems) {
            sum += (long)RLPEncoder.encodedLen(raw);
        }
        return RLPEncoder.requireNoOverflow(sum);
    }

    private static int encodedLen(Object raw) {
        if (raw instanceof byte[]) {
            return RLPEncoder.stringEncodedLen((byte[])raw);
        }
        if (raw instanceof Iterable) {
            return RLPEncoder.listEncodedLen((Iterable)raw);
        }
        if (raw instanceof Object[]) {
            return RLPEncoder.listEncodedLen(Arrays.asList((Object[])raw));
        }
        if (raw == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("unsupported object type: " + raw.getClass().getName());
    }

    private static int stringEncodedLen(byte[] byteString) {
        int dataLen = byteString.length;
        return RLPEncoder.itemLen(dataLen == 1 && DataType.isSingleByte(byteString[0]) ? 0 : dataLen);
    }

    private static int listEncodedLen(Iterable<?> items) {
        return RLPEncoder.itemLen(RLPEncoder.sumEncodedLen(items));
    }

    private static void encodeItem(Object raw, ByteBuffer bb) {
        if (raw instanceof byte[]) {
            RLPEncoder.encodeString((byte[])raw, bb);
        } else if (raw instanceof Iterable) {
            Iterable elements = (Iterable)raw;
            RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, bb);
        } else if (raw instanceof Object[]) {
            List<Object> elements = Arrays.asList((Object[])raw);
            RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, bb);
        } else {
            if (raw == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException("unsupported object type: " + raw.getClass().getName());
        }
    }

    private static void encodeLen1String(byte first, ByteBuffer bb) {
        if (first < 0) {
            bb.put((byte)-127);
        }
        bb.put(first);
    }

    private static void encodeList(int dataLen, Iterable<?> elements, ByteBuffer bb) {
        RLPEncoder.insertListPrefix(dataLen, bb);
        RLPEncoder.encodeSequentially(elements, bb);
    }

    public static byte[] encodeString(byte b) {
        return RLPEncoder.encodeString(new byte[]{b});
    }

    public static byte[] encodeString(byte[] byteString) {
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.stringEncodedLen(byteString));
        RLPEncoder.encodeString(byteString, bb);
        return bb.array();
    }

    public static void encodeString(byte[] byteString, ByteBuffer dest) {
        int dataLen = byteString.length;
        if (RLPEncoder.isShort(dataLen)) {
            if (dataLen == 1) {
                RLPEncoder.encodeLen1String(byteString[0], dest);
                return;
            }
            dest.put((byte)(-128 + dataLen));
        } else {
            dest.put((byte)(-73 + Integers.len(dataLen)));
            Integers.putLong(dataLen, dest);
        }
        dest.put(byteString);
    }

    public static byte[] encodeSequentially(Object ... objects) {
        return RLPEncoder.encodeSequentially(Arrays.asList(objects));
    }

    public static int encodeSequentially(Object[] objects, byte[] dest, int destIndex) {
        return RLPEncoder.encodeSequentially(Arrays.asList(objects), dest, destIndex);
    }

    public static void encodeSequentially(Object[] objects, ByteBuffer dest) {
        RLPEncoder.encodeSequentially(Arrays.asList(objects), dest);
    }

    public static byte[] encodeSequentially(Iterable<?> objects) {
        byte[] dest = new byte[RLPEncoder.sumEncodedLen(objects)];
        RLPEncoder.encodeSequentially(objects, dest, 0);
        return dest;
    }

    public static int encodeSequentially(Iterable<?> objects, byte[] dest, int destIndex) {
        ByteBuffer bb = ByteBuffer.wrap(dest, destIndex, dest.length - destIndex);
        RLPEncoder.encodeSequentially(objects, bb);
        return bb.position();
    }

    public static void encodeSequentially(Iterable<?> objects, ByteBuffer dest) {
        for (Object raw : objects) {
            RLPEncoder.encodeItem(raw, dest);
        }
    }

    public static byte[] encodeAsList(Object ... elements) {
        return RLPEncoder.encodeAsList(Arrays.asList(elements));
    }

    public static int encodeAsList(Object[] elements, byte[] dest, int destIndex) {
        return RLPEncoder.encodeAsList(Arrays.asList(elements), dest, destIndex);
    }

    public static void encodeAsList(Object[] elements, ByteBuffer dest) {
        RLPEncoder.encodeAsList(Arrays.asList(elements), dest);
    }

    public static byte[] encodeAsList(Iterable<?> elements) {
        int dataLen = RLPEncoder.sumEncodedLen(elements);
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.itemLen(dataLen));
        RLPEncoder.encodeList(dataLen, elements, bb);
        return bb.array();
    }

    public static int encodeAsList(Iterable<?> elements, byte[] dest, int destIndex) {
        ByteBuffer bb = ByteBuffer.wrap(dest, destIndex, dest.length - destIndex);
        RLPEncoder.encodeAsList(elements, bb);
        return bb.position();
    }

    public static void encodeAsList(Iterable<?> elements, ByteBuffer dest) {
        RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, dest);
    }

    public static RLPList toList(RLPItem ... encodings) {
        return RLPEncoder.toList(Arrays.asList(encodings));
    }

    public static RLPList toList(Iterable<RLPItem> encodings) {
        return RLPList.withElements(encodings);
    }
}

