/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.rlp.ShortInputException;
import com.esaulpaugh.headlong.rlp.util.FloatingPoint;
import com.esaulpaugh.headlong.rlp.util.Notation;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class RLPItem {
    public static final RLPItem[] EMPTY_ARRAY = new RLPItem[0];
    protected final byte[] buffer;
    protected final int index;
    public final transient int dataIndex;
    public final transient int dataLength;
    public final transient int endIndex;

    RLPItem(byte lead, DataType type, byte[] buffer, int index, int containerEnd, boolean lenient) {
        long _dataLength;
        int _dataIndex;
        containerEnd = Math.min(buffer.length, containerEnd);
        int diff = lead - type.offset;
        switch (type.ordinal()) {
            case 0: {
                _dataIndex = index;
                _dataLength = 1L;
                break;
            }
            case 1: 
            case 3: {
                _dataIndex = index + 1;
                _dataLength = diff;
                break;
            }
            case 2: 
            case 4: {
                int lengthIndex = index + 1;
                _dataIndex = lengthIndex + diff;
                if (_dataIndex > containerEnd) {
                    throw RLPItem.exceedsContainer(index, _dataIndex, containerEnd, containerEnd == buffer.length);
                }
                _dataLength = Integers.getLong(buffer, lengthIndex, diff, lenient);
                if (_dataLength >= 56L) break;
                throw new IllegalArgumentException("long element data length must be 56 or greater; found: " + _dataLength + " for element @ " + index);
            }
            default: {
                throw new Error();
            }
        }
        long _endIndex = (long)_dataIndex + _dataLength;
        if (_endIndex > (long)containerEnd) {
            throw RLPItem.exceedsContainer(index, _endIndex, containerEnd, containerEnd == buffer.length);
        }
        if (!lenient && _dataLength == 1L && type == DataType.STRING_SHORT && DataType.isSingleByte(buffer[_dataIndex])) {
            throw new IllegalArgumentException("invalid rlp for single byte @ " + index);
        }
        this.buffer = buffer;
        this.index = index;
        this.dataIndex = _dataIndex;
        this.dataLength = (int)_dataLength;
        this.endIndex = (int)_endIndex;
    }

    RLPItem(RLPItem it) {
        this.buffer = it.encoding();
        this.index = 0;
        this.dataIndex = this.buffer.length - it.dataLength;
        this.dataLength = it.dataLength;
        this.endIndex = this.buffer.length;
    }

    static IllegalArgumentException exceedsContainer(int index, long end, int containerEnd, boolean shortInput) {
        String msg = "element @ index " + index + " exceeds its container: " + end + " > " + containerEnd;
        return shortInput ? new ShortInputException(msg) : new IllegalArgumentException(msg);
    }

    public final DataType type() {
        return DataType.type(this.buffer[this.index]);
    }

    public abstract boolean isString();

    public abstract boolean isList();

    public abstract RLPString asRLPString();

    public abstract RLPList asRLPList();

    public abstract RLPItem duplicate();

    public final int encodingLength() {
        return this.endIndex - this.index;
    }

    public final byte[] encoding() {
        return this.copyOfRange(this.index, this.endIndex);
    }

    public final byte[] data() {
        return this.copyOfRange(this.dataIndex, this.endIndex);
    }

    public final byte[] copyOfRange(int from, int to) {
        byte[] range = new byte[to - from];
        this.exportRange(from, to, range, 0);
        return range;
    }

    public final int export(byte[] dest, int destIndex) {
        return this.exportRange(this.index, this.endIndex, dest, destIndex);
    }

    public final int exportData(byte[] dest, int destIndex) {
        return this.exportRange(this.dataIndex, this.endIndex, dest, destIndex);
    }

    public final void exportData(OutputStream os) throws IOException {
        os.write(this.buffer, this.dataIndex, this.dataLength);
    }

    public final int exportRange(int from, int to, byte[] dest, int destIndex) {
        if (from >= this.index) {
            if (to <= this.endIndex) {
                int len = to - from;
                System.arraycopy(this.buffer, from, dest, destIndex, len);
                return destIndex + len;
            }
            throw new IndexOutOfBoundsException(to + " > " + this.endIndex);
        }
        throw new IndexOutOfBoundsException(from + " < " + this.index);
    }

    public byte[] asBytes() {
        return this.data();
    }

    public String asString(int encoding) {
        return Strings.encode(this.buffer, this.dataIndex, this.dataLength, encoding);
    }

    public boolean asBoolean() {
        return this.dataLength != 0 && this.buffer[this.index] != 0;
    }

    public char asChar(boolean lenient) {
        return (char)this.asShort(lenient);
    }

    public byte asByte(boolean lenient) {
        return Integers.getByte(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public short asShort(boolean lenient) {
        return Integers.getShort(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public int asInt(boolean lenient) {
        return Integers.getInt(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public long asLong(boolean lenient) {
        return Integers.getLong(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public BigInteger asBigInt(boolean lenient) {
        return Integers.getBigInt(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public float asFloat(boolean lenient) {
        return FloatingPoint.getFloat(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public double asDouble(boolean lenient) {
        return FloatingPoint.getDouble(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public byte asByte() {
        return this.asByte(false);
    }

    public int asInt() {
        return this.asInt(false);
    }

    public long asLong() {
        return this.asLong(false);
    }

    public BigInteger asBigInt() {
        return this.asBigInt(false);
    }

    public BigInteger asBigIntSigned() {
        return new BigInteger(this.data());
    }

    public final int hashCode() {
        int result = 1;
        for (int i = this.index; i < this.endIndex; ++i) {
            result = 31 * result + this.buffer[i];
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RLPItem)) {
            return false;
        }
        RLPItem other = (RLPItem)o;
        return this.equals(other.buffer, other.index, other.endIndex);
    }

    private boolean equals(byte[] b, int bIdx, int bEnd) {
        int len = this.endIndex - this.index;
        if (len != bEnd - bIdx) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[this.index + i] == b[bIdx + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Notation.forEncoding(this.buffer, this.index, this.endIndex).toString();
    }

    public String encodingString(int encoding) {
        return Strings.encode(this.buffer, this.index, this.encodingLength(), encoding);
    }
}

