/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPStreamIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class RLPStream
implements Iterable<RLPItem>,
AutoCloseable {
    private final InputStream is;
    private final RLPDecoder decoder;

    public RLPStream(InputStream is) {
        this(is, RLPDecoder.RLP_STRICT);
    }

    public RLPStream(InputStream is, RLPDecoder decoder) {
        this.is = is;
        this.decoder = decoder;
    }

    public ArrayList<RLPItem> collect() {
        return this.collect(new ArrayList());
    }

    public <T extends Collection<RLPItem>> T collect(T collection) {
        for (RLPItem item : this) {
            collection.add((RLPItem)item);
        }
        return collection;
    }

    @Override
    public Iterator<RLPItem> iterator() {
        return new RLPStreamIterator(this.is, this.decoder);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

