/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Strings;

public final class FastBase64 {
    public static final int NO_FLAGS = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_LINE_SEP = 2;
    public static final int URL_SAFE_CHARS = 4;
    private static final int LINE_LEN = 76;
    private static final int LINE_SEP_LEN = 2;
    private static final byte PADDING_BYTE = 61;
    private static final short[] URL_SAFE = FastBase64.table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");

    private FastBase64() {
    }

    static short[] table(String alphabet) {
        byte[] bytes = Strings.decode(alphabet, 3);
        short[] table = new short[4096];
        int i = 0;
        int offset = 0;
        while (i < bytes.length) {
            int leftBits = bytes[i] << 8;
            for (int j = 0; j < bytes.length; ++j) {
                table[offset + j] = (short)(leftBits | bytes[j] & 0xFF);
            }
            ++i;
            offset += bytes.length;
        }
        return table;
    }

    public static String encodeToString(byte[] buffer, int offset, int len, int flags) {
        byte[] enc = FastBase64.encodeToBytes(buffer, offset, len, flags);
        return new String(enc, 0, 0, enc.length);
    }

    public static byte[] encodeToBytes(byte[] buffer, int offset, int len, int flags) {
        int chunks = len / 3;
        int evenBytes = chunks * 3;
        int bytesLeft = len - evenBytes;
        int chars = chunks * 4;
        int charsLeft = 0;
        if (bytesLeft > 0) {
            charsLeft = (flags & 1) != 0 ? bytesLeft + 1 : 4;
            chars += charsLeft;
        }
        int endEvenBytes = offset + evenBytes;
        short[] table = (flags & 4) != 0 ? URL_SAFE : Standard.STANDARD;
        byte[] out = (flags & 2) != 0 ? FastBase64.encodeMain(buffer, offset, table, endEvenBytes, chars) : FastBase64.encodeMainLineSep(buffer, offset, table, endEvenBytes, chars + (chars - 1) / 76 * 2);
        FastBase64.insertRemainder(buffer, bytesLeft, charsLeft, table, endEvenBytes, out);
        return out;
    }

    private static byte[] encodeMain(byte[] buffer, int i, short[] table, int end, int len) {
        byte[] out = new byte[len];
        int o = 0;
        while (i < end) {
            int _24bits = (buffer[i++] & 0xFF) << 16 | (buffer[i++] & 0xFF) << 8 | buffer[i++] & 0xFF;
            short ab = table[_24bits >>> 12];
            short cd = table[_24bits & 0xFFF];
            out[o++] = (byte)(ab >>> 8);
            out[o++] = (byte)ab;
            out[o++] = (byte)(cd >>> 8);
            out[o++] = (byte)cd;
        }
        return out;
    }

    private static byte[] encodeMainLineSep(byte[] buffer, int i, short[] table, int end, int len) {
        byte[] out = new byte[len];
        int quadruples = 0;
        int lineSepLimit = out.length - 2;
        int o = 0;
        while (i < end) {
            int _24bits = (buffer[i++] & 0xFF) << 16 | (buffer[i++] & 0xFF) << 8 | buffer[i++] & 0xFF;
            short ab = table[_24bits >>> 12];
            short cd = table[_24bits & 0xFFF];
            out[o++] = (byte)(ab >>> 8);
            out[o++] = (byte)ab;
            out[o++] = (byte)(cd >>> 8);
            out[o++] = (byte)cd;
            if (++quadruples < 19 || o >= lineSepLimit) continue;
            out[o++] = 13;
            out[o++] = 10;
            quadruples = 0;
        }
        return out;
    }

    private static void insertRemainder(byte[] buffer, int numBytes, int numChars, short[] table, int endEvenBytes, byte[] out) {
        int bits = 0;
        int thirdChar = 61;
        switch (numBytes) {
            case 2: {
                bits = (buffer[endEvenBytes + 1] & 0xFF) << 2;
                thirdChar = table[bits & 0x3F];
            }
            case 1: {
                bits |= (buffer[endEvenBytes] & 0xFF) << 10;
                int charsIdx = out.length - numChars;
                switch (numChars) {
                    case 4: {
                        out[charsIdx + 3] = 61;
                    }
                    case 3: {
                        out[charsIdx + 2] = (byte)thirdChar;
                    }
                    case 2: {
                        out[charsIdx + 1] = (byte)table[bits >> 6 & 0x3F];
                    }
                }
                out[charsIdx] = (byte)table[bits >> 12];
            }
        }
    }

    private static final class Standard {
        static final short[] STANDARD = FastBase64.table("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");

        private Standard() {
        }
    }
}

