/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Integers;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class FastHex {
    private static final int CHARS_PER_BYTE = 2;
    private static final int BITS_PER_CHAR = 4;
    private static final short[] ENCODE_TABLE = new short[256];
    private static final byte[] DECODE_TABLE = new byte[256];
    private static final byte NO_MAPPING = -1;

    private FastHex() {
    }

    public static String encodeToString(byte ... buffer) {
        return FastHex.encodeToString(buffer, 0, buffer.length);
    }

    public static String encodeToString(byte[] buffer, int offset, int len) {
        byte[] enc = FastHex.encodeToBytes(buffer, offset, len);
        return new String(enc, 0, 0, enc.length);
    }

    public static byte[] encodeToBytes(byte[] buffer, int offset, int len) {
        int end = offset + len;
        byte[] bytes = new byte[len * 2];
        int j = 0;
        while (offset < end) {
            short hexPair = ENCODE_TABLE[buffer[offset] & 0xFF];
            bytes[j] = (byte)(hexPair >>> 8);
            bytes[j + 1] = (byte)hexPair;
            ++offset;
            j += 2;
        }
        return bytes;
    }

    public static byte[] decode(String hex) {
        return FastHex.decode(hex, 0, hex.length());
    }

    public static byte[] decode(String hex, int offset, int len) {
        return FastHex.decode(hex.getBytes(StandardCharsets.US_ASCII), offset, len);
    }

    public static byte[] decode(byte[] hexBytes, int offset, int len) {
        if (Integers.mod(len, 2) == 0) {
            int bytesLen = len / 2;
            byte[] bytes = new byte[bytesLen];
            int i = 0;
            while (i < bytesLen) {
                byte left = DECODE_TABLE[hexBytes[offset]];
                byte right = DECODE_TABLE[hexBytes[offset + 1]];
                if (left == -1 || right == -1) {
                    throw new IllegalArgumentException("illegal hex val @ " + (left == -1 ? offset : offset + 1));
                }
                bytes[i] = (byte)(left << 4 | right);
                ++i;
                offset += 2;
            }
            return bytes;
        }
        throw new IllegalArgumentException("len must be a multiple of two");
    }

    static {
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int leftNibbleMask = 240;
        int rightNibbleMask = 15;
        for (int i = 0; i < ENCODE_TABLE.length; ++i) {
            char leftChar = chars[(i & 0xF0) >>> 4];
            char rightChar = chars[i & 0xF];
            FastHex.ENCODE_TABLE[i] = (short)(leftChar << 8 | rightChar);
        }
        Arrays.fill(DECODE_TABLE, (byte)-1);
        FastHex.DECODE_TABLE[48] = 0;
        FastHex.DECODE_TABLE[49] = 1;
        FastHex.DECODE_TABLE[50] = 2;
        FastHex.DECODE_TABLE[51] = 3;
        FastHex.DECODE_TABLE[52] = 4;
        FastHex.DECODE_TABLE[53] = 5;
        FastHex.DECODE_TABLE[54] = 6;
        FastHex.DECODE_TABLE[55] = 7;
        FastHex.DECODE_TABLE[56] = 8;
        FastHex.DECODE_TABLE[57] = 9;
        FastHex.DECODE_TABLE[97] = 10;
        FastHex.DECODE_TABLE[65] = 10;
        FastHex.DECODE_TABLE[98] = 11;
        FastHex.DECODE_TABLE[66] = 11;
        FastHex.DECODE_TABLE[99] = 12;
        FastHex.DECODE_TABLE[67] = 12;
        FastHex.DECODE_TABLE[100] = 13;
        FastHex.DECODE_TABLE[68] = 13;
        FastHex.DECODE_TABLE[101] = 14;
        FastHex.DECODE_TABLE[69] = 14;
        FastHex.DECODE_TABLE[102] = 15;
        FastHex.DECODE_TABLE[70] = 15;
    }
}

