/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.abi.util.JsonUtils;
import com.esaulpaugh.headlong.util.FastHex;
import com.esaulpaugh.headlong.util.Strings;
import com.google.gson.JsonObject;
import com.joemelsha.crypto.hash.Keccak;
import java.util.Arrays;
import java.util.Objects;

public final class Event
implements ABIObject {
    private static final ArrayType<ByteType, byte[]> BYTES_32 = (ArrayType)TypeFactory.create("bytes32");
    public static final byte[][] EMPTY_TOPICS = new byte[0][];
    private final String name;
    private final boolean anonymous;
    private final TupleType inputs;
    private final TupleType indexedParams;
    private final TupleType nonIndexedParams;
    private final boolean[] indexManifest;
    private final byte[] signatureHash;

    public static Event create(String name, TupleType inputs, boolean ... indexed) {
        return new Event(name, false, inputs, indexed);
    }

    public static Event createAnonymous(String name, TupleType inputs, boolean ... indexed) {
        return new Event(name, true, inputs, indexed);
    }

    public Event(String name, boolean anonymous, TupleType inputs, boolean ... indexed) {
        this.name = Objects.requireNonNull(name);
        this.inputs = Objects.requireNonNull(inputs);
        if (indexed.length != inputs.size()) {
            throw new IllegalArgumentException("indexed.length doesn't match number of inputs");
        }
        this.indexManifest = Arrays.copyOf(indexed, indexed.length);
        this.indexedParams = inputs.select(this.indexManifest);
        this.nonIndexedParams = inputs.exclude(this.indexManifest);
        this.anonymous = anonymous;
        this.signatureHash = new Keccak(256).digest(Strings.decode(this.getCanonicalSignature(), 3));
    }

    @Override
    public TypeEnum getType() {
        return TypeEnum.EVENT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TupleType getInputs() {
        return this.inputs;
    }

    public boolean[] getIndexManifest() {
        return Arrays.copyOf(this.indexManifest, this.indexManifest.length);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name + this.inputs.canonicalType;
    }

    public TupleType getIndexedParams() {
        return this.indexedParams;
    }

    public TupleType getNonIndexedParams() {
        return this.nonIndexedParams;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.name.hashCode() + this.inputs.hashCode()) + Arrays.hashCode(this.indexManifest)) + Boolean.hashCode(this.anonymous);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        return other.anonymous == this.anonymous && other.name.equals(this.name) && other.inputs.equals(this.inputs) && Arrays.equals(other.indexManifest, this.indexManifest);
    }

    public static Event fromJson(String eventJson) {
        return Event.fromJsonObject(JsonUtils.parseObject(eventJson));
    }

    public static Event fromJsonObject(JsonObject event) {
        return ABIJSON.parseEvent(event);
    }

    public String toString() {
        return this.toJson(true);
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public Tuple decodeTopics(byte[][] topics) {
        return new Tuple(this.decodeTopicsArray(topics));
    }

    public Tuple decodeData(byte[] data) {
        return data == null && this.nonIndexedParams.isEmpty() ? Tuple.EMPTY : (Tuple)this.nonIndexedParams.decode(Objects.requireNonNull(data));
    }

    public Tuple decodeArgs(byte[][] topics, byte[] data) {
        return this.mergeDecodedArgs(this.decodeTopicsArray(topics), this.decodeData(data));
    }

    private Tuple mergeDecodedArgs(Object[] decodedTopics, Tuple decodedData) {
        Object[] result = new Object[this.inputs.size()];
        int topicIndex = 0;
        int dataIndex = 0;
        for (int i = 0; i < this.indexManifest.length; ++i) {
            result[i] = this.indexManifest[i] ? decodedTopics[topicIndex++] : decodedData.get(dataIndex++);
        }
        return new Tuple(result);
    }

    private Object[] decodeTopicsArray(byte[][] topics) {
        if (this.anonymous) {
            this.checkAnonymousTopics(topics);
        } else {
            this.checkNonAnonymousTopics(topics);
        }
        int offset = this.anonymous ? 0 : 1;
        Object[] decodedTopics = new Object[this.indexedParams.size()];
        for (int i = 0; i < decodedTopics.length; ++i) {
            Object abiType = this.indexedParams.get(i);
            byte[] topic = topics[i + offset];
            decodedTopics[i] = ((ABIType)abiType).isDynamic() ? BYTES_32.decode(topic) : ((ABIType)abiType).decode(topic);
        }
        return decodedTopics;
    }

    private void checkAnonymousTopics(byte[][] topics) {
        topics = this.indexedParams.isEmpty() && topics == null ? EMPTY_TOPICS : Objects.requireNonNull(topics, "non-null topics expected");
        this.checkTopicsLength(topics.length, 0);
    }

    private void checkNonAnonymousTopics(byte[][] topics) {
        Objects.requireNonNull(topics, "non-null topics expected");
        this.checkTopicsLength(topics.length, 1);
        byte[] decodedSignatureHash = (byte[])BYTES_32.decode(topics[0]);
        if (!Arrays.equals(this.signatureHash, decodedSignatureHash)) {
            throw new IllegalArgumentException("unexpected topics[0]: event " + this.getCanonicalSignature() + " expects " + FastHex.encodeToString(this.signatureHash) + " but found " + FastHex.encodeToString(decodedSignatureHash));
        }
    }

    private void checkTopicsLength(int len, int offset) {
        int expectedTopics = this.indexedParams.size() + offset;
        if (len != expectedTopics) {
            throw new IllegalArgumentException("expected topics.length == " + expectedTopics + " but found length " + len);
        }
    }
}

