/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Tuple
implements Iterable<Object> {
    public static final Tuple EMPTY = new Tuple(new Object[0]);
    static final Object ABSENT = new Object(){

        public String toString() {
            return "-ABSENT-";
        }
    };
    final Object[] elements;

    public Tuple(Object ... elements) {
        this.elements = Arrays.copyOf(elements, elements.length);
    }

    public <T> T get(int index) {
        Object val = this.elements[index];
        if (val == ABSENT) {
            throw new NoSuchElementException("not present because index was not specified for decoding: " + index);
        }
        return (T)val;
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Tuple && Arrays.deepEquals(((Tuple)o).elements, this.elements);
    }

    public String toString() {
        return Arrays.deepToString(this.elements);
    }

    public Tuple subtuple(int startIndex, int endIndex) {
        return new Tuple(Arrays.copyOfRange(this.elements, startIndex, endIndex));
    }

    public static Tuple of(Object ... elements) {
        return new Tuple(elements);
    }

    public static Tuple singleton(Object element) {
        return new Tuple(element);
    }

    public List<Object> toList() {
        return Collections.unmodifiableList(Arrays.asList(this.elements));
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this.elements).iterator();
    }
}

