/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.SuperSerial;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;

public final class TupleType
extends ABIType<Tuple>
implements Iterable<ABIType<?>> {
    private static final String EMPTY_TUPLE_STRING = "()";
    public static final TupleType EMPTY = new TupleType("()", false, EMPTY_ARRAY, null);
    final ABIType<?>[] elementTypes;
    private final int headLength;

    private TupleType(String canonicalType, boolean dynamic, ABIType<?>[] elementTypes, String name) {
        super(canonicalType, Tuple.class, dynamic, name);
        this.elementTypes = elementTypes;
        this.headLength = dynamic ? 32 : TupleType.staticTupleHeadLength(this);
    }

    static TupleType wrap(String name, ABIType<?> ... elements) {
        StringBuilder canonicalBuilder = new StringBuilder("(");
        boolean dynamic = false;
        for (ABIType<?> e : elements) {
            canonicalBuilder.append(e.canonicalType).append(',');
            dynamic |= e.dynamic;
        }
        return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, elements, name);
    }

    public int size() {
        return this.elementTypes.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public <T extends ABIType<?>> T get(int index) {
        return (T)this.elementTypes[index];
    }

    public ABIType<Object> getNonCapturing(int index) {
        return this.elementTypes[index];
    }

    @Override
    Class<?> arrayClass() {
        return Tuple[].class;
    }

    @Override
    public int typeCode() {
        return 7;
    }

    @Override
    int headLength() {
        return this.headLength;
    }

    @Override
    int dynamicByteLength(Object value) {
        Object[] elements = ((Tuple)value).elements;
        return this.countBytes(i -> TupleType.measureObject(this.get(i), elements[i]));
    }

    @Override
    int byteLength(Object value) {
        if (!this.dynamic) {
            return this.headLength;
        }
        Object[] elements = ((Tuple)value).elements;
        return this.countBytes(i -> TupleType.measureObject(this.get(i), elements[i]));
    }

    private static int measureObject(ABIType<?> type, Object value) {
        return TupleType.totalLen(type.byteLength(value), type.dynamic);
    }

    @Override
    public int byteLengthPacked(Object value) {
        Object[] elements = value != null ? ((Tuple)value).elements : new Object[this.size()];
        return this.countBytes(i -> ((ABIType)this.get(i)).byteLengthPacked(elements[i]));
    }

    private int countBytes(IntUnaryOperator counter) {
        return TupleType.countBytes(false, this.elementTypes.length, 0, counter);
    }

    static int countBytes(boolean array, int len, int count, IntUnaryOperator counter) {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                count += counter.applyAsInt(i);
            }
            return count;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException((array ? "array" : "tuple") + " index " + i + ": " + iae.getMessage(), iae);
        }
    }

    @Override
    public int validate(Tuple value) {
        if (value.size() == this.size()) {
            return this.countBytes(i -> TupleType.validateObject(this.get(i), value.elements[i]));
        }
        throw new IllegalArgumentException("tuple length mismatch: actual != expected: " + value.size() + " != " + this.size());
    }

    private static int validateObject(ABIType<?> type, Object value) {
        try {
            return TupleType.totalLen(type._validate(value), type.dynamic);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("null", npe);
        }
    }

    static int totalLen(int byteLen, boolean addUnit) {
        return addUnit ? 32 + byteLen : byteLen;
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        Object[] vals = ((Tuple)value).elements;
        TupleType.encodeObjects(this.dynamic, vals, this::get, dest, this.dynamic ? this.headLength(vals) : -1);
    }

    private int headLength(Object[] elements) {
        int sum = 0;
        for (int i = 0; i < elements.length; ++i) {
            sum += ((ABIType)this.get(i)).headLength();
        }
        return sum;
    }

    @Override
    void encodePackedUnchecked(Tuple value, ByteBuffer dest) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ABIType)this.get(i)).encodeObjectPackedUnchecked(value.elements[i], dest);
        }
    }

    static void encodeObjects(boolean dynamic, Object[] values, IntFunction<ABIType<?>> getType, ByteBuffer dest, int offset) {
        int i;
        for (i = 0; i < values.length; ++i) {
            offset = getType.apply(i).encodeHead(values[i], dest, offset);
        }
        if (dynamic) {
            for (i = 0; i < values.length; ++i) {
                ABIType<?> t = getType.apply(i);
                if (!t.dynamic) continue;
                t.encodeTail(values[i], dest);
            }
        }
    }

    @Override
    Tuple decode(ByteBuffer bb, byte[] unitBuffer) {
        Object[] elements = new Object[this.size()];
        TupleType.decodeObjects(this.dynamic, bb, unitBuffer, this::get, elements);
        return new Tuple(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T decode(ByteBuffer bb, int ... indices) {
        bb.mark();
        try {
            if (indices.length == 1) {
                T t = this.decodeIndex(bb, indices[0]);
                return t;
            }
            if (indices.length == 0) {
                throw new IllegalArgumentException("must specify at least one index");
            }
            Tuple tuple = this.decodeIndices(bb, indices);
            return (T)tuple;
        }
        finally {
            bb.reset();
        }
    }

    private void ensureIndexInBounds(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        if (index >= this.elementTypes.length) {
            throw new IllegalArgumentException("index " + index + " out of bounds for tuple type of length " + this.elementTypes.length);
        }
    }

    private <T> T decodeIndex(ByteBuffer bb, int index) {
        this.ensureIndexInBounds(index);
        int skipBytes = 0;
        for (int j = 0; j < index; ++j) {
            skipBytes += this.elementTypes[j].headLength();
        }
        int pos = bb.position();
        bb.position(pos + skipBytes);
        ABIType<?> resultType = this.elementTypes[index];
        byte[] unitBuffer = TupleType.newUnitBuffer();
        if (resultType.dynamic) {
            bb.position(pos + Encoding.UINT31.decode(bb, unitBuffer));
        }
        return (T)resultType.decode(bb, unitBuffer);
    }

    private Tuple decodeIndices(ByteBuffer bb, int ... indices) {
        Object[] results = new Object[this.elementTypes.length];
        int pos = bb.position();
        byte[] unitBuffer = TupleType.newUnitBuffer();
        int i = 0;
        int j = 0;
        int skipBytes = 0;
        int prevIndex = -1;
        do {
            int index = indices[i++];
            this.ensureIndexInBounds(index);
            if (index <= prevIndex) {
                throw new IllegalArgumentException("index out of order: " + index);
            }
            while (j < index) {
                results[j] = Tuple.ABSENT;
                skipBytes += this.elementTypes[j].headLength();
                ++j;
            }
            bb.position(pos + skipBytes);
            ABIType<?> resultType = this.elementTypes[j++];
            if (resultType.dynamic) {
                bb.position(pos + Encoding.UINT31.decode(bb, unitBuffer));
            }
            results[index] = resultType.decode(bb, unitBuffer);
            skipBytes += resultType.headLength();
            prevIndex = index;
        } while (i < indices.length);
        while (j < this.elementTypes.length) {
            results[j] = Tuple.ABSENT;
            ++j;
        }
        return new Tuple(results);
    }

    static int staticTupleHeadLength(TupleType tt) {
        int len = 0;
        block4: for (ABIType<?> e : tt) {
            switch (e.typeCode()) {
                case 6: {
                    len += ArrayType.staticArrayHeadLength(e);
                    continue block4;
                }
                case 7: {
                    len += TupleType.staticTupleHeadLength((TupleType)e);
                    continue block4;
                }
            }
            len += 32;
        }
        return len;
    }

    static void decodeObjects(boolean dynamic, ByteBuffer bb, byte[] unitBuffer, IntFunction<ABIType<?>> getType, Object[] objects) {
        int i;
        if (!dynamic) {
            for (int i2 = 0; i2 < objects.length; ++i2) {
                objects[i2] = getType.apply(i2).decode(bb, unitBuffer);
            }
            return;
        }
        int start = bb.position();
        int[] offsets = new int[objects.length];
        for (i = 0; i < objects.length; ++i) {
            ABIType<?> t = getType.apply(i);
            if (!t.dynamic) {
                objects[i] = t.decode(bb, unitBuffer);
                continue;
            }
            offsets[i] = Encoding.UINT31.decode(bb, unitBuffer);
        }
        for (i = 0; i < objects.length; ++i) {
            int offset = offsets[i];
            if (offset <= 0) continue;
            int jump = start + offset;
            int pos = bb.position();
            if (jump != pos) {
                if (jump < pos) {
                    boolean shared = false;
                    for (int j = 0; j < i; ++j) {
                        if (offsets[j] != offset) continue;
                        shared = true;
                        break;
                    }
                    if (!shared) {
                        throw new IllegalArgumentException("illegal backwards jump: (" + start + "+" + offset + "=" + jump + ")<" + pos);
                    }
                }
                bb.position(jump);
            }
            objects[i] = getType.apply(i).decode(bb, unitBuffer);
        }
    }

    @Override
    public Tuple parseArgument(String s) {
        return SuperSerial.deserialize(this, s, false);
    }

    public ByteBuffer encodeElements(Object ... elements) {
        return this.encode(new Tuple(elements));
    }

    @Override
    public Iterator<ABIType<?>> iterator() {
        return Arrays.asList(this.elementTypes).iterator();
    }

    public TupleType select(boolean ... manifest) {
        return this.selectElements(manifest, false);
    }

    public TupleType exclude(boolean ... manifest) {
        return this.selectElements(manifest, true);
    }

    private TupleType selectElements(boolean[] manifest, boolean negate) {
        int size = this.size();
        if (manifest.length == size) {
            StringBuilder canonicalBuilder = new StringBuilder("(");
            boolean dynamic = false;
            ArrayList selected = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                if (!(negate ^ manifest[i])) continue;
                Object e = this.get(i);
                canonicalBuilder.append(((ABIType)e).canonicalType).append(',');
                dynamic |= ((ABIType)e).dynamic;
                selected.add(e);
            }
            return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, selected.toArray(EMPTY_ARRAY), null);
        }
        throw new IllegalArgumentException("manifest.length != size(): " + manifest.length + " != " + size);
    }

    private static String completeTupleTypeString(StringBuilder sb) {
        int len = sb.length();
        return len != 1 ? sb.deleteCharAt(len - 1).append(')').toString() : EMPTY_TUPLE_STRING;
    }

    public static TupleType parse(String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(rawTupleTypeString);
    }

    public static TupleType of(String ... typeStrings) {
        StringBuilder sb = new StringBuilder("(");
        for (String str : typeStrings) {
            sb.append(str).append(',');
        }
        return TupleType.parse(TupleType.completeTupleTypeString(sb));
    }
}

