/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.AddressType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.Integers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class TypeFactory {
    static final int ADDRESS_BIT_LEN = 160;
    private static final int DECIMAL_BIT_LEN = 128;
    private static final int DECIMAL_SCALE = 10;
    private static final int FIXED_BIT_LEN = 128;
    private static final int FIXED_SCALE = 18;
    private static final int FUNCTION_BYTE_LEN = 24;
    static final Map<String, Function<String, ABIType<?>>> SUPPLIER_MAP;

    private TypeFactory() {
    }

    private static void mapInt(Map<String, Function<String, ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, name -> new IntType(type, bitLen, unsigned, (String)name));
    }

    private static void mapLong(Map<String, Function<String, ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, name -> new LongType(type, bitLen, unsigned, (String)name));
    }

    private static void mapBigInteger(Map<String, Function<String, ABIType<?>>> map, String type, int bitLen, boolean unsigned) {
        map.put(type, name -> new BigIntegerType(type, bitLen, unsigned, (String)name));
    }

    private static void mapByteArray(Map<String, Function<String, ABIType<?>>> map, String type, int arrayLen) {
        map.put(type, name -> new ArrayType<ByteType, byte[]>(type, byte[].class, ByteType.SIGNED, arrayLen, byte[][].class, (String)name));
    }

    public static <T extends ABIType<?>> T create(String rawType) {
        return TypeFactory.create(rawType, null);
    }

    public static ABIType<Object> createNonCapturing(String rawType) {
        return TypeFactory.create(rawType, null);
    }

    public static <T extends ABIType<?>> T create(String rawType, String name) {
        return (T)TypeFactory.build(rawType, name, null);
    }

    static ABIType<?> createWithBase(String rawType, String name, ABIType<?> baseType) {
        return TypeFactory.build(rawType, name, baseType);
    }

    private static ABIType<?> build(String rawType, String name, ABIType<?> baseType) {
        try {
            int lastCharIdx = rawType.length() - 1;
            if (rawType.charAt(lastCharIdx) == ']') {
                int secondToLastCharIdx = lastCharIdx - 1;
                int arrayOpenIndex = rawType.lastIndexOf(91, secondToLastCharIdx);
                ABIType<?> elementType = TypeFactory.build(rawType.substring(0, arrayOpenIndex), null, baseType);
                String type = elementType.canonicalType + rawType.substring(arrayOpenIndex);
                int length = arrayOpenIndex == secondToLastCharIdx ? -1 : TypeFactory.parseLen(rawType.substring(arrayOpenIndex + 1, lastCharIdx));
                return new ArrayType(type, elementType.arrayClass(), elementType, length, null, name);
            }
            if (baseType != null || (baseType = TypeFactory.resolveBaseType(rawType, name)) != null) {
                return baseType;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException("unrecognized type: \"" + rawType + '\"');
    }

    private static int parseLen(String lenStr) {
        try {
            if (TypeFactory.leadDigitValid(lenStr.charAt(0)) || "0".equals(lenStr)) {
                return Integer.parseInt(lenStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("bad array length");
    }

    private static ABIType<?> resolveBaseType(String baseTypeStr, String name) {
        if (baseTypeStr.charAt(0) == '(') {
            return TypeFactory.parseTupleType(baseTypeStr, name);
        }
        Function<String, ABIType<?>> init = SUPPLIER_MAP.get(baseTypeStr);
        return init != null ? init.apply(name) : TypeFactory.tryParseFixed(baseTypeStr, name);
    }

    private static BigDecimalType tryParseFixed(String type, String name) {
        int idx = type.indexOf("fixed");
        boolean unsigned = false;
        if (idx == 0 || (unsigned = idx == 1 && type.charAt(0) == 'u')) {
            int indexOfX = type.lastIndexOf(120);
            try {
                String mStr = type.substring(idx + "fixed".length(), indexOfX);
                String nStr = type.substring(indexOfX + 1);
                if (TypeFactory.leadDigitValid(mStr.charAt(0)) && TypeFactory.leadDigitValid(nStr.charAt(0))) {
                    int M = Integer.parseInt(mStr);
                    int N = Integer.parseInt(nStr);
                    if (Integers.isMultiple(M, 8) && M <= 256 && N <= 80) {
                        return new BigDecimalType((unsigned ? "ufixed" : "fixed") + M + 'x' + N, M, N, unsigned, name);
                    }
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean leadDigitValid(char c) {
        return c > '0' && c <= '9';
    }

    private static TupleType parseTupleType(String rawTypeStr, String name) {
        ArrayList elements = new ArrayList();
        try {
            int argStart = 1;
            int argEnd = 1;
            int terminator = 41;
            int last = rawTypeStr.length() - 1;
            while (argStart <= last) {
                char c = rawTypeStr.charAt(argStart);
                if (c == ',' || c == ')' && terminator == 44) {
                    throw new IllegalArgumentException("empty parameter");
                }
                if (c != ')') {
                    argEnd = TypeFactory.findArgEnd(rawTypeStr, argStart, c);
                    elements.add(TypeFactory.build(rawTypeStr.substring(argStart, argEnd), null, null));
                    terminator = rawTypeStr.charAt(argEnd);
                }
                if (terminator == 41) {
                    return argEnd == last ? TupleType.wrap(name, elements.toArray(ABIType.EMPTY_ARRAY)) : null;
                }
                argStart = argEnd + 1;
            }
            return null;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("@ index " + elements.size() + ", " + iae.getMessage(), iae);
        }
    }

    private static int findArgEnd(String rawTypeStr, int argStart, char c) {
        return TypeFactory.nextTerminator(rawTypeStr, c == '(' ? TypeFactory.findSubtupleEnd(rawTypeStr, argStart) : argStart);
    }

    private static int findSubtupleEnd(String parentTypeString, int i) {
        int depth = 1;
        do {
            char x;
            if ((x = parentTypeString.charAt(++i)) > ')') continue;
            if (x == ')') {
                --depth;
                continue;
            }
            if (x != '(') continue;
            ++depth;
        } while (depth > 0);
        return i + 1;
    }

    private static int nextTerminator(String signature, int i) {
        int len = signature.length();
        while (i < len) {
            char c = signature.charAt(i);
            if (c == ',' || c == ')') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static {
        int n;
        HashMap lambdaMap = new HashMap(256);
        for (n = 8; n <= 32; n += 8) {
            TypeFactory.mapInt(lambdaMap, "int" + n, n, false);
        }
        for (n = 40; n <= 64; n += 8) {
            TypeFactory.mapLong(lambdaMap, "int" + n, n, false);
        }
        for (n = 72; n <= 256; n += 8) {
            TypeFactory.mapBigInteger(lambdaMap, "int" + n, n, false);
        }
        for (n = 8; n <= 24; n += 8) {
            TypeFactory.mapInt(lambdaMap, "uint" + n, n, true);
        }
        for (n = 32; n <= 56; n += 8) {
            TypeFactory.mapLong(lambdaMap, "uint" + n, n, true);
        }
        for (n = 64; n <= 256; n += 8) {
            TypeFactory.mapBigInteger(lambdaMap, "uint" + n, n, true);
        }
        for (n = 1; n <= 32; ++n) {
            TypeFactory.mapByteArray(lambdaMap, "bytes" + n, n);
        }
        lambdaMap.put("address", AddressType::new);
        TypeFactory.mapByteArray(lambdaMap, "function", 24);
        TypeFactory.mapByteArray(lambdaMap, "bytes", -1);
        lambdaMap.put("string", name -> new ArrayType<ByteType, String>("string", ArrayType.STRING_CLASS, ByteType.SIGNED, -1, ArrayType.STRING_ARRAY_CLASS, (String)name));
        lambdaMap.put("fixed128x18", name -> new BigDecimalType("fixed128x18", 128, 18, false, (String)name));
        lambdaMap.put("ufixed128x18", name -> new BigDecimalType("ufixed128x18", 128, 18, true, (String)name));
        lambdaMap.put("decimal", name -> new BigDecimalType("decimal", 128, 10, false, (String)name));
        lambdaMap.put("int", (Function)lambdaMap.get("int256"));
        lambdaMap.put("uint", (Function)lambdaMap.get("uint256"));
        lambdaMap.put("fixed", (Function)lambdaMap.get("fixed128x18"));
        lambdaMap.put("ufixed", (Function)lambdaMap.get("ufixed128x18"));
        lambdaMap.put("bool", BooleanType::new);
        SUPPLIER_MAP = Collections.unmodifiableMap(lambdaMap);
    }
}

