/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

public class RLPOutputStream
extends OutputStream {
    private final OutputStream out;

    public RLPOutputStream(OutputStream out) {
        this.out = Objects.requireNonNull(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.writeOut(RLPEncoder.encodeString((byte)b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeOut(RLPEncoder.encodeString(b));
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        this.writeOut(RLPEncoder.encodeString(Arrays.copyOfRange(buffer, offset, offset + len)));
    }

    public void writeAll(Object ... rawObjects) throws IOException {
        this.writeOut(RLPEncoder.encodeSequentially(rawObjects));
    }

    public void writeAll(Iterable<?> rawObjects) throws IOException {
        this.writeOut(RLPEncoder.encodeSequentially(rawObjects));
    }

    public void writeList(Object ... rawElements) throws IOException {
        this.writeOut(RLPEncoder.encodeAsList(rawElements));
    }

    public void writeList(Iterable<?> rawElements) throws IOException {
        this.writeOut(RLPEncoder.encodeAsList(rawElements));
    }

    private void writeOut(byte[] rlp) throws IOException {
        this.out.write(rlp, 0, rlp.length);
    }

    public String toString() {
        return this.out.toString();
    }

    public static class Baos
    extends ByteArrayOutputStream {
        Baos() {
        }

        @Override
        public synchronized String toString() {
            return Strings.encode(this.buf, 0, this.count, 0);
        }
    }
}

