/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.util.FastHex;
import com.joemelsha.crypto.hash.Keccak;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class Address {
    private static final int PREFIX_LEN = 2;
    private static final int ADDRESS_DATA_BYTES = 20;
    private static final int ADDRESS_HEX_CHARS = 40;
    private static final int ADDRESS_LEN_CHARS = 42;
    private static final int HEX_RADIX = 16;
    public static final int MAX_LABEL_LEN = 36;
    private final BigInteger value;
    private final String label;

    Address(BigInteger value) {
        this(value, null);
    }

    private Address(BigInteger value, String label) {
        this.value = value;
        this.label = label;
    }

    public BigInteger value() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Address) {
            Address other = (Address)o;
            return this.value.equals(other.value);
        }
        return false;
    }

    public String toString() {
        return Address.toChecksumAddress(this.value);
    }

    public static Address wrap(String checksumAddress) {
        return new Address(Address.validateAndDecodeAddress(checksumAddress));
    }

    public static Address wrap(String checksumAddress, String label) {
        if (label != null && label.length() > 36) {
            throw new IllegalArgumentException("label length exceeds maximum: " + label.length() + " > " + 36);
        }
        return new Address(Address.validateAndDecodeAddress(checksumAddress), label);
    }

    private static BigInteger validateAndDecodeAddress(String checksumAddress) {
        Address.validateChecksumAddress(checksumAddress);
        byte[] bytes = new byte[21];
        FastHex.decode(checksumAddress, 2, 40, bytes, 1);
        return new BigInteger(bytes);
    }

    public Address withLabel(String label) {
        if (this.label != null) {
            throw new IllegalArgumentException("labeling aborted because existing label not null");
        }
        return Address.wrap(this.toString(), label);
    }

    public static void validateChecksumAddress(String checksumAddress) {
        if (Address.toChecksumAddress(checksumAddress).equals(checksumAddress)) {
            return;
        }
        throw new IllegalArgumentException("invalid checksum");
    }

    public static String toChecksumAddress(BigInteger address) {
        String minimalHex = address.toString(16);
        int start = 42 - minimalHex.length();
        if (start < 2) {
            throw new IllegalArgumentException("invalid bit length: " + address.bitLength());
        }
        byte[] addressBytes = "0x0000000000000000000000000000000000000000".getBytes(StandardCharsets.US_ASCII);
        int i = start;
        do {
            addressBytes[i] = (byte)minimalHex.charAt(i - start);
        } while (++i < addressBytes.length);
        return Address.doChecksum(addressBytes);
    }

    public static String toChecksumAddress(String address) {
        if (address.length() == 42) {
            Address.checkPrefix(address);
            byte[] addressBytes = "0x0000000000000000000000000000000000000000".getBytes(StandardCharsets.US_ASCII);
            for (int i = 2; i < addressBytes.length; ++i) {
                addressBytes[i] = (byte)Address.getLowercaseHex(address, i);
            }
            return Address.doChecksum(addressBytes);
        }
        if (address.length() >= 2) {
            Address.checkPrefix(address);
        }
        throw new IllegalArgumentException("expected address length 42; actual is " + address.length());
    }

    private static void checkPrefix(String address) {
        if (address.charAt(0) != '0' || address.charAt(1) != 'x') {
            throw new IllegalArgumentException("missing 0x prefix");
        }
    }

    private static String doChecksum(byte[] addressBytes) {
        Keccak keccak256 = new Keccak(256);
        keccak256.update(addressBytes, 2, 40);
        boolean offset = true;
        byte[] buffer = new byte[21];
        keccak256.digest(ByteBuffer.wrap(buffer, 1, 20));
        byte[] hash = FastHex.encodeToBytes(buffer);
        for (int i = 2; i < addressBytes.length; ++i) {
            switch (hash[i]) {
                case 56: 
                case 57: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    addressBytes[i] = (byte)Character.toUpperCase(addressBytes[i]);
                }
            }
        }
        return new String(addressBytes, 0, 0, addressBytes.length);
    }

    private static int getLowercaseHex(String address, int i) {
        char c = address.charAt(i);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c + 32;
            }
        }
        throw new IllegalArgumentException("illegal hex val @ " + i);
    }
}

