/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class KVP
implements Comparable<KVP> {
    public static final KVP[] EMPTY_ARRAY = new KVP[0];
    public static final String ID = "id";
    public static final String SECP256K1 = "secp256k1";
    public static final String IP = "ip";
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    public static final String IP6 = "ip6";
    public static final String TCP6 = "tcp6";
    public static final String UDP6 = "udp6";
    private final byte[] k;
    private final byte[] v;
    private final int keyDataIdx;
    final int length;

    public KVP(String keyUtf8, String val, int valEncoding) {
        this(keyUtf8, Strings.decode(val, valEncoding));
    }

    public KVP(String keyUtf8, byte[] rawVal) {
        this(Strings.decode(keyUtf8, 1), rawVal);
    }

    public KVP(byte[] key, byte[] value) {
        this.k = RLPEncoder.encodeString(key);
        this.v = RLPEncoder.encodeString(value);
        this.keyDataIdx = this.key().dataIndex;
        this.length = this.k.length + this.v.length;
    }

    public KVP(RLPItem key, RLPItem value) {
        this(key.encoding(), value.encoding(), key.dataIndex);
    }

    private KVP(byte[] k, byte[] v, int i) {
        this.k = k;
        this.v = v;
        this.keyDataIdx = i;
        this.length = k.length + v.length;
    }

    public KVP withValue(String val, int valEncoding) {
        return this.withValue(Strings.decode(val, valEncoding));
    }

    public KVP withValue(byte[] value) {
        return new KVP(this.k, RLPEncoder.encodeString(value), this.keyDataIdx);
    }

    public RLPString key() {
        return RLPDecoder.RLP_STRICT.wrapString(this.k);
    }

    public RLPString value() {
        return RLPDecoder.RLP_STRICT.wrapString(this.v);
    }

    void export(ByteBuffer bb) {
        bb.put(this.k).put(this.v);
    }

    public int hashCode() {
        return Arrays.hashCode(this.k);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof KVP && Arrays.equals(((KVP)o).k, this.k);
    }

    public String toString() {
        return this.key().asString(1) + " --> " + this.value().asString(0);
    }

    @Override
    public int compareTo(KVP other) {
        int result = KVP.compare(this, other);
        if (result == 0) {
            throw this.duplicateKeyErr();
        }
        return result;
    }

    private static int compare(KVP pa, KVP pb) {
        byte[] a = pa.k;
        byte[] b = pb.k;
        int aOff = pa.keyDataIdx;
        int bOff = pb.keyDataIdx;
        int aLen = a.length - aOff;
        int bLen = b.length - bOff;
        int end = aOff + Math.min(aLen, bLen);
        while (aOff < end) {
            byte bv;
            byte av;
            if ((av = a[aOff++]) == (bv = b[bOff++])) continue;
            return av - bv;
        }
        return aLen - bLen;
    }

    IllegalArgumentException duplicateKeyErr() {
        return new IllegalArgumentException("duplicate key: " + this.key().asString(1));
    }
}

