/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class BigIntegerType
extends UnitType<BigInteger> {
    BigIntegerType(String canonicalType, int bitLength, boolean unsigned, String name) {
        super(canonicalType, BigInteger.class, bitLength, unsigned, name);
    }

    @Override
    Class<?> arrayClass() {
        return BigInteger[].class;
    }

    @Override
    public int typeCode() {
        return 4;
    }

    @Override
    public int validate(BigInteger value) {
        return this.validateBigInt(value);
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        Encoding.insertInt((BigInteger)value, 32, dest);
    }

    @Override
    void encodePackedUnchecked(BigInteger value, ByteBuffer dest) {
        Encoding.insertInt(value, this.byteLengthPacked(null), dest);
    }

    @Override
    BigInteger decode(ByteBuffer bb, byte[] unitBuffer) {
        return this.decodeValid(bb, unitBuffer);
    }

    @Override
    public BigInteger parseArgument(String s) {
        BigInteger bigInt = new BigInteger(s);
        this.validate(bigInt);
        return bigInt;
    }
}

