/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Tuple
implements Iterable<Object> {
    public static final Tuple EMPTY = new Tuple(new Object[0]);
    final Object[] elements;

    public Tuple(Object ... elements) {
        this.elements = Arrays.copyOf(elements, elements.length);
    }

    public <T> T get(int index) {
        Object val = this.elements[index];
        if (val == null) {
            throw new NoSuchElementException("" + index);
        }
        return (T)val;
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Tuple && Arrays.deepEquals(((Tuple)o).elements, this.elements);
    }

    public String toString() {
        return Arrays.deepToString(this.elements);
    }

    public Tuple subtuple(int startIndex, int endIndex) {
        return new Tuple(Arrays.copyOfRange(this.elements, startIndex, endIndex));
    }

    public static Tuple of(Object ... elements) {
        return new Tuple(elements);
    }

    public static Tuple singleton(Object element) {
        return new Tuple(element);
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this.elements).iterator();
    }
}

