/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class UnitType<J>
extends ABIType<J> {
    public static final int UNIT_LENGTH_BYTES = 32;
    final int bitLength;
    final boolean unsigned;

    UnitType(String canonicalType, Class<J> clazz, int bitLength, boolean unsigned, String name) {
        super(canonicalType, clazz, false, name);
        this.bitLength = bitLength;
        this.unsigned = unsigned;
    }

    public final int getBitLength() {
        return this.bitLength;
    }

    public final boolean isUnsigned() {
        return this.unsigned;
    }

    public final BigInteger minValue() {
        return this.unsigned ? BigInteger.ZERO : BigInteger.valueOf(2L).pow(this.bitLength - 1).negate();
    }

    public final BigInteger maxValue() {
        return BigInteger.valueOf(2L).pow(this.unsigned ? this.bitLength : this.bitLength - 1).subtract(BigInteger.ONE);
    }

    @Override
    int byteLengthPacked(Object value) {
        return this.bitLength / 8;
    }

    @Override
    public int validate(J value) {
        return this.validatePrimitive(UnitType.toLong(value));
    }

    @Override
    void encodeTail(Object value, ByteBuffer dest) {
        Encoding.insertInt(UnitType.toLong(value), dest);
    }

    @Override
    void encodePackedUnchecked(J value, ByteBuffer dest) {
        LongType.encodeLong(UnitType.toLong(value), this.byteLengthPacked(null), dest);
    }

    private static long toLong(Object value) {
        return ((Number)value).longValue();
    }

    final int validatePrimitive(long longVal) {
        if (longVal < 0L) {
            if (this.unsigned) {
                throw new IllegalArgumentException("signed value given for unsigned type");
            }
            longVal ^= 0xFFFFFFFFFFFFFFFFL;
        }
        this.checkBitLen(Integers.bitLen(longVal));
        return 32;
    }

    final int validateBigInt(BigInteger bigIntVal) {
        int foundBitLen = bigIntVal.bitLength();
        if (this.unsigned) {
            if (bigIntVal.signum() < 0) {
                throw new IllegalArgumentException("signed value given for unsigned type");
            }
            if (foundBitLen > this.bitLength) {
                throw new IllegalArgumentException("unsigned val exceeds bit limit: " + foundBitLen + " > " + this.bitLength);
            }
        } else if (foundBitLen >= this.bitLength) {
            throw new IllegalArgumentException("signed val exceeds bit limit: " + foundBitLen + " >= " + this.bitLength);
        }
        return 32;
    }

    private void checkBitLen(int actual) {
        if (this.unsigned) {
            if (actual > this.bitLength) {
                throw new IllegalArgumentException("unsigned val exceeds bit limit: " + actual + " > " + this.bitLength);
            }
        } else if (actual >= this.bitLength) {
            throw new IllegalArgumentException("signed val exceeds bit limit: " + actual + " >= " + this.bitLength);
        }
    }

    final BigInteger decodeValid(ByteBuffer bb, byte[] unitBuffer) {
        int idx = 0;
        if (this.unsigned) {
            unitBuffer = new byte[33];
            idx = 1;
        }
        bb.get(unitBuffer, idx, 32);
        BigInteger bi = new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi;
    }
}

