/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.ShortInputException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RLPSequenceIterator
implements Iterator<RLPItem> {
    final RLPDecoder decoder;
    byte[] buffer;
    int index;
    RLPItem next;

    RLPSequenceIterator(RLPDecoder decoder, byte[] buffer, int index) {
        this.decoder = decoder;
        this.buffer = buffer;
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.index < this.buffer.length) {
            this.next = this.decoder.wrap(this.buffer, this.index);
            this.index = this.next.endIndex;
            return true;
        }
        return false;
    }

    @Override
    public RLPItem next() {
        if (this.hasNext()) {
            RLPItem item = this.next;
            this.next = null;
            this.index = item.endIndex;
            return item;
        }
        throw new NoSuchElementException();
    }

    static final class StreamRLPSequenceIterator
    extends RLPSequenceIterator {
        final InputStream is;

        StreamRLPSequenceIterator(InputStream is, RLPDecoder decoder) {
            super(decoder, new byte[0], 0);
            this.is = is;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            try {
                int available = this.is.available();
                if (available > 0) {
                    int keptBytes = this.buffer.length - this.index;
                    byte[] newBuffer = new byte[keptBytes + available];
                    System.arraycopy(this.buffer, this.index, newBuffer, 0, keptBytes);
                    this.buffer = newBuffer;
                    this.index = 0;
                    int read = this.is.read(this.buffer, keptBytes, available);
                    if (read != available) {
                        throw new IOException("read failed: " + read + " != " + available);
                    }
                } else if (this.index >= this.buffer.length) {
                    return false;
                }
                this.next = this.decoder.wrap(this.buffer, this.index);
                return true;
            }
            catch (ShortInputException e) {
                return false;
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }
}

