/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.KVP;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public final class Record {
    private static final long MAX_RECORD_LEN = 300L;
    private static final String ENR_PREFIX = "enr:";
    private final RLPList rlp;

    public static ByteBuffer encode(Signer signer, long seq, KVP ... pairs) {
        return Record.encode(signer, seq, Arrays.asList(pairs));
    }

    public static ByteBuffer encode(Signer signer, long seq, List<KVP> pairs) {
        if (seq < 0L) {
            throw new IllegalArgumentException("negative seq");
        }
        int signatureLen = signer.signatureLength();
        if (signatureLen < 0) {
            throw new InvalidParameterException("signer specifies negative signature length");
        }
        int payloadLen = RLPEncoder.payloadLen(seq, pairs);
        int recordDataLen = RLPEncoder.itemLen(signatureLen) + payloadLen;
        byte[] record = new byte[Record.checkRecordLen(RLPEncoder.itemLen(recordDataLen))];
        byte[] content = RLPEncoder.encodeRecordContent(payloadLen, seq, pairs);
        System.arraycopy(content, content.length - payloadLen, record, record.length - payloadLen, payloadLen);
        byte[] signature = signer.sign(content);
        if (signature.length != signatureLen) {
            throw new InvalidParameterException("unexpected signature length: " + signature.length + " != " + signatureLen);
        }
        ByteBuffer bb = ByteBuffer.wrap(record);
        RLPEncoder.insertListPrefix(recordDataLen, bb);
        RLPEncoder.encodeString(signature, bb);
        return bb;
    }

    public Record(Signer signer, long seq, KVP ... pairs) {
        this(signer, seq, Arrays.asList(pairs));
    }

    public Record(Signer signer, long seq, List<KVP> pairs) {
        this.rlp = RLPDecoder.RLP_STRICT.wrapList(Record.encode(signer, seq, pairs).array());
    }

    private Record(RLPList recordRLP) {
        this.rlp = recordRLP;
    }

    private static int checkRecordLen(int recordLen) {
        if ((long)recordLen > 300L) {
            throw new IllegalArgumentException("record length exceeds maximum: " + recordLen + " > " + 300L);
        }
        return recordLen;
    }

    public Record with(Signer signer, long seq, KVP ... newPairs) {
        HashSet<KVP> pairSet = new HashSet<KVP>();
        for (KVP pair : newPairs) {
            if (pairSet.add(pair)) continue;
            throw pair.duplicateKeyErr();
        }
        this.visitAll((k, v) -> pairSet.add(new KVP((RLPItem)k, (RLPItem)v)));
        return new Record(signer, seq, pairSet.toArray(KVP.EMPTY_ARRAY));
    }

    public static Record parse(String enrString, Verifier verifier) throws SignatureException {
        if (enrString.startsWith(ENR_PREFIX)) {
            byte[] bytes = Strings.decode(enrString.substring(ENR_PREFIX.length()), 2);
            return Record.decode(bytes, verifier);
        }
        throw new IllegalArgumentException("prefix \"enr:\" not found");
    }

    public static Record decode(byte[] bytes, Verifier verifier) throws SignatureException {
        Record.checkRecordLen(bytes.length);
        RLPList rlpList = RLPDecoder.RLP_STRICT.wrapList(bytes).duplicate();
        if (rlpList.encodingLength() != bytes.length) {
            throw new IllegalArgumentException("unconsumed trailing bytes");
        }
        Record record = new Record(rlpList);
        RLPString signatureItem = record.getSignature();
        byte[] content = record.content(signatureItem.endIndex);
        verifier.verify(signatureItem.asBytes(), content);
        return record;
    }

    public RLPList getRLP() {
        return this.rlp;
    }

    public RLPString getSignature() {
        return this.rlp.iterator(RLPDecoder.RLP_STRICT).next().asRLPString();
    }

    public RLPList getContent() {
        return RLPDecoder.RLP_STRICT.wrapList(this.content(this.getSignature().endIndex));
    }

    public long getSeq() {
        return this.visitAll(null);
    }

    public List<KVP> getPairs() {
        ArrayList<KVP> list = new ArrayList<KVP>();
        this.visitAll((k, v) -> list.add(new KVP((RLPItem)k, (RLPItem)v)));
        return list;
    }

    public Map<String, byte[]> map() {
        LinkedHashMap<String, byte[]> map = new LinkedHashMap<String, byte[]>();
        this.visitAll((k, v) -> map.put(k.asString(1), v.asBytes()));
        return map;
    }

    public long visitAll(BiConsumer<RLPItem, RLPItem> visitor) {
        Iterator<RLPItem> iter = this.rlp.iterator();
        iter.next();
        long seq = iter.next().asLong();
        if (visitor != null) {
            while (iter.hasNext()) {
                visitor.accept(iter.next(), iter.next());
            }
        }
        return seq;
    }

    private byte[] content(int index) {
        int contentDataLen = this.rlp.encodingLength() - index;
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.itemLen(contentDataLen));
        RLPEncoder.insertListPrefix(contentDataLen, bb);
        byte[] arr = bb.array();
        System.arraycopy(this.rlp.buffer, index, arr, bb.position(), contentDataLen);
        return arr;
    }

    public int hashCode() {
        return this.rlp.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Record && ((Record)o).rlp.equals(this.rlp);
    }

    public String toString() {
        return ENR_PREFIX + this.rlp.encodingString(2);
    }

    @FunctionalInterface
    public static interface Verifier {
        public void verify(byte[] var1, byte[] var2) throws SignatureException;
    }

    public static interface Signer {
        public int signatureLength();

        public byte[] sign(byte[] var1);
    }
}

