/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.rlp.Notation;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class SuperSerial {
    private static final byte[] TRUE = new byte[]{1};
    private static final byte[] FALSE = Strings.EMPTY_BYTE_ARRAY;

    private SuperSerial() {
    }

    public static String serialize(TupleType tupleType, Tuple tuple, boolean machine) {
        tupleType.validate(tuple);
        Object[] objects = SuperSerial.serializeTuple(tupleType, tuple);
        return machine ? Strings.encode(RLPEncoder.encodeSequentially(objects)) : Notation.forObjects(objects).toString();
    }

    public static Tuple deserialize(TupleType tupleType, String str, boolean machine) {
        Tuple in = SuperSerial.deserializeTuple(tupleType, machine ? Strings.decode(str) : RLPEncoder.encodeSequentially(Notation.parse(str)));
        tupleType.validate(in);
        return in;
    }

    public static <T> T deserializeArray(ArrayType<? extends ABIType<?>, T> arrayType, String str, boolean machine) {
        byte[] rlp = machine ? Strings.decode(str) : RLPEncoder.encodeSequentially(Notation.parse(str));
        Object array = SuperSerial.deserializeArray(arrayType, RLPDecoder.RLP_STRICT.wrap(rlp));
        arrayType._validate(array);
        return (T)array;
    }

    private static Object[] serializeTuple(TupleType tupleType, Tuple tuple) {
        Object[] out = new Object[tupleType.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = SuperSerial.serialize(tupleType.get(i), tuple.get(i));
        }
        return out;
    }

    private static Tuple deserializeTuple(TupleType tupleType, byte[] sequence) {
        Iterator<RLPItem> sequenceIterator = RLPDecoder.RLP_STRICT.sequenceIterator(sequence);
        Object[] elements = new Object[tupleType.size()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = SuperSerial.deserialize(tupleType.get(i), sequenceIterator.next());
        }
        if (sequenceIterator.hasNext()) {
            throw new IllegalArgumentException("trailing unconsumed items");
        }
        return new Tuple(elements);
    }

    private static Object serialize(ABIType<?> type, Object obj) {
        switch (type.typeCode()) {
            case 0: {
                return SuperSerial.serializeBoolean((Boolean)obj);
            }
            case 1: {
                return Integers.toBytes((Byte)obj);
            }
            case 2: 
            case 3: {
                return SuperSerial.serializeBigInteger((UnitType)type, BigInteger.valueOf(((Number)obj).longValue()));
            }
            case 4: {
                return SuperSerial.serializeBigInteger((UnitType)type, (BigInteger)obj);
            }
            case 5: {
                return SuperSerial.serializeBigInteger((UnitType)type, ((BigDecimal)obj).unscaledValue());
            }
            case 6: {
                return SuperSerial.serializeArray((ArrayType)type, obj);
            }
            case 7: {
                return SuperSerial.serializeTuple((TupleType)type, (Tuple)obj);
            }
            case 8: {
                return SuperSerial.serializeBigInteger((UnitType)type, ((Address)obj).value());
            }
        }
        throw new AssertionError();
    }

    private static byte[] serializeBoolean(boolean val) {
        return val ? TRUE : FALSE;
    }

    private static Object deserialize(ABIType<?> type, RLPItem item) {
        if (type.typeCode() < 6 && item.isList()) {
            throw new IllegalArgumentException("RLPList not allowed for this type: " + type);
        }
        switch (type.typeCode()) {
            case 0: {
                return item.asBoolean();
            }
            case 1: {
                return item.asByte();
            }
            case 2: {
                return SuperSerial.deserializeBigInteger((UnitType)type, item).intValueExact();
            }
            case 3: {
                return SuperSerial.deserializeBigInteger((UnitType)type, item).longValueExact();
            }
            case 4: {
                return SuperSerial.deserializeBigInteger((UnitType)type, item);
            }
            case 5: {
                BigDecimalType bdt = (BigDecimalType)type;
                return new BigDecimal(SuperSerial.deserializeBigInteger(bdt, item), bdt.getScale());
            }
            case 6: {
                return SuperSerial.deserializeArray((ArrayType)type, item);
            }
            case 7: {
                return SuperSerial.deserializeTuple((TupleType)type, item.asBytes());
            }
            case 8: {
                return Address.wrap(Address.toChecksumAddress(SuperSerial.deserializeBigInteger((UnitType)type, item)));
            }
        }
        throw new AssertionError();
    }

    private static byte[] serializeBigInteger(UnitType<?> ut, BigInteger val) {
        if (ut.isUnsigned()) {
            return Integers.toBytesUnsigned(val);
        }
        if (val.signum() != 0) {
            byte[] bytes = val.toByteArray();
            return val.signum() < 0 ? SuperSerial.signExtendNegative(bytes, ut.getBitLength() / 8) : (bytes[0] != 0 ? bytes : Arrays.copyOfRange(bytes, 1, bytes.length));
        }
        return Strings.EMPTY_BYTE_ARRAY;
    }

    private static byte[] signExtendNegative(byte[] negative, int newWidth) {
        byte[] extended = new byte[newWidth];
        Arrays.fill(extended, (byte)-1);
        System.arraycopy(negative, 0, extended, newWidth - negative.length, negative.length);
        return extended;
    }

    private static BigInteger deserializeBigInteger(UnitType<?> ut, RLPItem item) {
        return ut.isUnsigned() ? item.asBigInt(true) : (item.dataLength * 8 < ut.getBitLength() ? item.asBigInt(false) : item.asBigIntSigned());
    }

    private static Object serializeArray(ArrayType<? extends ABIType<?>, ?> type, Object arr) {
        switch (type.getElementType().typeCode()) {
            case 0: {
                return SuperSerial.serializeBooleanArray((boolean[])arr);
            }
            case 1: {
                return SuperSerial.serializeByteArray(arr, type.isString());
            }
            case 2: {
                return SuperSerial.serializeIntArray((UnitType)type.getElementType(), (int[])arr);
            }
            case 3: {
                return SuperSerial.serializeLongArray((UnitType)type.getElementType(), (long[])arr);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return SuperSerial.serializeObjectArray(type.getElementType(), (Object[])arr);
            }
        }
        throw new AssertionError();
    }

    private static Object deserializeArray(ArrayType<? extends ABIType<?>, ?> type, RLPItem item) {
        switch (type.getElementType().typeCode()) {
            case 0: {
                return SuperSerial.deserializeBooleanArray((RLPList)item);
            }
            case 1: {
                return SuperSerial.deserializeByteArray(item, type.isString());
            }
            case 2: {
                return SuperSerial.deserializeIntArray((IntType)type.getElementType(), (RLPList)item);
            }
            case 3: {
                return SuperSerial.deserializeLongArray((LongType)type.getElementType(), (RLPList)item);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return SuperSerial.deserializeObjectArray(type.getElementType(), (RLPList)item);
            }
        }
        throw new AssertionError();
    }

    private static byte[][] serializeBooleanArray(boolean[] booleans) {
        byte[][] out = new byte[booleans.length][];
        for (int i = 0; i < booleans.length; ++i) {
            out[i] = SuperSerial.serializeBoolean(booleans[i]);
        }
        return out;
    }

    private static boolean[] deserializeBooleanArray(RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        boolean[] in = new boolean[elements.size()];
        for (int i = 0; i < in.length; ++i) {
            in[i] = elements.get(i).asBoolean();
        }
        return in;
    }

    private static byte[] serializeByteArray(Object arr, boolean isString) {
        return isString ? Strings.decode((String)arr, 1) : (byte[])arr;
    }

    private static Object deserializeByteArray(RLPItem item, boolean isString) {
        return isString ? (Object)item.asString(1) : item.asBytes();
    }

    private static byte[][] serializeIntArray(UnitType<?> ut, int[] values) {
        byte[][] out = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            out[i] = SuperSerial.serializeBigInteger(ut, BigInteger.valueOf(values[i]));
        }
        return out;
    }

    private static int[] deserializeIntArray(IntType type, RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        int[] in = new int[elements.size()];
        for (int i = 0; i < in.length; ++i) {
            in[i] = SuperSerial.deserializeBigInteger(type, elements.get(i)).intValueExact();
        }
        return in;
    }

    private static byte[][] serializeLongArray(UnitType<?> ut, long[] values) {
        byte[][] out = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            out[i] = SuperSerial.serializeBigInteger(ut, BigInteger.valueOf(values[i]));
        }
        return out;
    }

    private static long[] deserializeLongArray(LongType type, RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        long[] in = new long[elements.size()];
        for (int i = 0; i < in.length; ++i) {
            in[i] = SuperSerial.deserializeBigInteger(type, elements.get(i)).longValueExact();
        }
        return in;
    }

    private static Object[] serializeObjectArray(ABIType<?> elementType, Object[] objects) {
        Object[] out = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            out[i] = SuperSerial.serialize(elementType, objects[i]);
        }
        return out;
    }

    private static Object[] deserializeObjectArray(ABIType<?> elementType, RLPList list) {
        List<RLPItem> elements = list.elements(RLPDecoder.RLP_STRICT);
        Object[] in = (Object[])Array.newInstance(elementType.clazz(), elements.size());
        for (int i = 0; i < in.length; ++i) {
            in[i] = SuperSerial.deserialize(elementType, elements.get(i));
        }
        return in;
    }
}

