/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class BigDecimalType
extends UnitType<BigDecimal> {
    final int scale;

    BigDecimalType(String canonicalTypeString, int bitLength, int scale, boolean unsigned) {
        super(canonicalTypeString, BigDecimal.class, bitLength, unsigned);
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public BigDecimal minDecimal() {
        return new BigDecimal(this.minValue(), this.scale);
    }

    public BigDecimal maxDecimal() {
        return new BigDecimal(this.maxValue(), this.scale);
    }

    @Override
    Class<?> arrayClass() {
        return BigDecimal[].class;
    }

    @Override
    public int typeCode() {
        return 5;
    }

    @Override
    void validateInternal(BigDecimal value) {
        if (value.scale() != this.scale) {
            throw new IllegalArgumentException("BigDecimal scale mismatch: actual != expected: " + value.scale() + " != " + this.scale);
        }
        this.validateBigInt(value.unscaledValue());
    }

    @Override
    void encodeTail(BigDecimal value, ByteBuffer dest) {
        Encoding.insertInt(value.unscaledValue(), 32, dest);
    }

    @Override
    void encodePackedUnchecked(BigDecimal value, ByteBuffer dest) {
        Encoding.insertInt(value.unscaledValue(), this.byteLengthPacked(null), dest);
    }

    @Override
    BigDecimal decode(ByteBuffer bb, byte[] unitBuffer) {
        return new BigDecimal(this.decodeValid(bb, unitBuffer), this.scale);
    }

    @Override
    public BigDecimal parseArgument(String s) {
        BigDecimal bigDec = new BigDecimal(new BigInteger(s, 10), this.scale);
        this.validate(bigDec);
        return bigDec;
    }
}

