/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.abi.util.Uint;
import com.esaulpaugh.headlong.util.Integers;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

final class PackedDecoder {
    private PackedDecoder() {
    }

    static Tuple decode(TupleType tupleType, byte[] buffer) {
        int count = PackedDecoder.countDynamics(tupleType);
        if (count <= 1) {
            Object[] elements = new Tuple[1];
            PackedDecoder.decodeTuple(tupleType, buffer, 0, buffer.length, elements, 0);
            Object tuple = elements[0];
            tupleType.validate((Tuple)tuple);
            int decodedLen = tupleType.byteLengthPacked((Tuple)tuple);
            if (decodedLen != buffer.length) {
                throw new IllegalArgumentException("unconsumed bytes: " + (buffer.length - decodedLen) + " remaining");
            }
            return tuple;
        }
        throw new IllegalArgumentException("multiple dynamic elements: " + count);
    }

    static int countDynamics(ABIType<?> type) {
        if (type.dynamic) {
            switch (type.typeCode()) {
                case 6: {
                    ArrayType at = (ArrayType)type;
                    return -1 == at.getLength() ? 1 + PackedDecoder.countDynamics(at.getElementType()) : PackedDecoder.countDynamics(at.getElementType());
                }
                case 7: {
                    int numDynamic = 0;
                    for (ABIType<?> e : ((TupleType)type).elementTypes) {
                        numDynamic += PackedDecoder.countDynamics(e);
                    }
                    return numDynamic;
                }
            }
            throw new AssertionError();
        }
        return 0;
    }

    private static int decodeTuple(TupleType tupleType, byte[] buffer, int start, int end, Object[] parentElements, int pei) {
        int i;
        Object[] elements = new Object[tupleType.size()];
        int mark = -1;
        block4: for (i = tupleType.size() - 1; i >= 0; --i) {
            Object type = tupleType.get(i);
            if (((ABIType)type).dynamic) {
                mark = i;
                break;
            }
            switch (((ABIType)type).typeCode()) {
                case 6: {
                    ArrayType arrayType = (ArrayType)type;
                    PackedDecoder.insertArray(arrayType, buffer, end -= ((ABIType)arrayType.getElementType()).byteLengthPacked(null) * arrayType.getLength(), end, elements, i);
                    continue block4;
                }
                case 7: {
                    end -= PackedDecoder.decodeTupleStatic((TupleType)type, buffer, end - ((ABIType)type).byteLengthPacked(null), end, elements, i);
                    continue block4;
                }
                default: {
                    end -= PackedDecoder.decode(tupleType.get(i), buffer, end - ((ABIType)type).byteLengthPacked(null), end, elements, i);
                }
            }
        }
        if (mark > -1) {
            for (i = 0; i <= mark; ++i) {
                start += PackedDecoder.decode(tupleType.get(i), buffer, start, end, elements, i);
            }
        }
        Tuple t = new Tuple(elements);
        parentElements[pei] = t;
        return tupleType.byteLengthPacked(t);
    }

    private static int decode(ABIType<?> type, byte[] buffer, int idx, int end, Object[] elements, int i) {
        switch (type.typeCode()) {
            case 0: {
                elements[i] = BooleanType.decodeBoolean(buffer[idx]);
                return type.byteLengthPacked(null);
            }
            case 1: {
                elements[i] = buffer[idx];
                return type.byteLengthPacked(null);
            }
            case 2: {
                return PackedDecoder.insertInt((IntType)type, buffer, idx, type.byteLengthPacked(null), elements, i);
            }
            case 3: {
                return PackedDecoder.insertLong((LongType)type, buffer, idx, type.byteLengthPacked(null), elements, i);
            }
            case 4: {
                return PackedDecoder.insertBigInteger((BigIntegerType)type, type.byteLengthPacked(null), buffer, idx, elements, i);
            }
            case 5: {
                return PackedDecoder.insertBigDecimal((BigDecimalType)type, type.byteLengthPacked(null), buffer, idx, elements, i);
            }
            case 6: {
                return PackedDecoder.insertArray((ArrayType)type, buffer, idx, end, elements, i);
            }
            case 7: {
                return type.dynamic ? PackedDecoder.decodeTuple((TupleType)type, buffer, idx, end, elements, i) : PackedDecoder.decodeTupleStatic((TupleType)type, buffer, idx, end, elements, i);
            }
            case 8: {
                return PackedDecoder.insertAddress(type.byteLengthPacked(null), buffer, idx, elements, i);
            }
        }
        throw new AssertionError();
    }

    private static int decodeTupleStatic(TupleType tupleType, byte[] buffer, int idx, int end, Object[] parentElements, int pei) {
        Object[] elements = new Object[tupleType.size()];
        for (int i = 0; i < elements.length; ++i) {
            idx += PackedDecoder.decode(tupleType.get(i), buffer, idx, end, elements, i);
        }
        Tuple t = new Tuple(elements);
        parentElements[pei] = t;
        return tupleType.byteLengthPacked(t);
    }

    private static int insertInt(UnitType<? extends Number> type, byte[] buffer, int idx, int len, Object[] dest, int destIdx) {
        dest[destIdx] = (int)PackedDecoder.decodeLong(type, buffer, idx, len);
        return len;
    }

    private static int insertLong(UnitType<? extends Number> type, byte[] buffer, int idx, int len, Object[] dest, int destIdx) {
        dest[destIdx] = PackedDecoder.decodeLong(type, buffer, idx, len);
        return len;
    }

    private static int insertBigInteger(BigIntegerType type, int elementLen, byte[] buffer, int idx, Object[] dest, int destIdx) {
        dest[destIdx] = type.unsigned ? Integers.getBigInt(buffer, idx, elementLen, true) : new BigInteger(Arrays.copyOfRange(buffer, idx, idx + elementLen));
        return elementLen;
    }

    private static int insertAddress(int elementLen, byte[] buffer, int idx, Object[] dest, int destIdx) {
        dest[destIdx] = new Address(Integers.getBigInt(buffer, idx, elementLen, true));
        return elementLen;
    }

    private static int insertBigDecimal(BigDecimalType type, int elementLen, byte[] buffer, int idx, Object[] dest, int destIdx) {
        BigInteger unscaled = type.unsigned ? Integers.getBigInt(buffer, idx, elementLen, true) : new BigInteger(Arrays.copyOfRange(buffer, idx, idx + elementLen));
        dest[destIdx] = new BigDecimal(unscaled, type.scale);
        return elementLen;
    }

    private static int insertArray(ArrayType<? extends ABIType<?>, ?> arrayType, byte[] buffer, int idx, int end, Object[] dest, int destIdx) {
        Object array;
        int arrayLen;
        ABIType<?> elementType = arrayType.getElementType();
        int elementByteLen = elementType.byteLengthPacked(null);
        int typeLen = arrayType.getLength();
        if (-1 == typeLen) {
            if (elementByteLen == 0) {
                throw new IllegalArgumentException("can't decode dynamic number of zero-length elements");
            }
            arrayLen = (end - idx) / elementByteLen;
        } else {
            arrayLen = typeLen;
        }
        switch (elementType.typeCode()) {
            case 0: {
                array = PackedDecoder.decodeBooleanArray(arrayLen, buffer, idx);
                break;
            }
            case 1: {
                array = PackedDecoder.decodeByteArray(arrayType, arrayLen, buffer, idx);
                break;
            }
            case 2: {
                array = PackedDecoder.decodeIntArray((IntType)elementType, elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 3: {
                array = PackedDecoder.decodeLongArray((LongType)elementType, elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 4: {
                array = PackedDecoder.decodeBigIntegerArray((BigIntegerType)elementType, elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 5: {
                array = PackedDecoder.decodeBigDecimalArray((BigDecimalType)elementType, elementByteLen, arrayLen, buffer, idx);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                array = PackedDecoder.decodeObjectArray(arrayLen, elementType, buffer, idx, end);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        dest[destIdx] = array;
        return arrayLen * elementByteLen;
    }

    private static boolean[] decodeBooleanArray(int arrayLen, byte[] buffer, int idx) {
        boolean[] booleans = new boolean[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            booleans[i] = BooleanType.decodeBoolean(buffer[idx + i]);
        }
        return booleans;
    }

    private static Object decodeByteArray(ArrayType<?, ?> arrayType, int arrayLen, byte[] buffer, int idx) {
        byte[] bytes = new byte[arrayLen];
        System.arraycopy(buffer, idx, bytes, 0, arrayLen);
        return arrayType.encodeIfString(bytes);
    }

    private static int[] decodeIntArray(IntType intType, int elementLen, int arrayLen, byte[] buffer, int idx) {
        long[] longs = PackedDecoder.decodeLongArray(intType, elementLen, arrayLen, buffer, idx);
        int[] ints = new int[arrayLen];
        for (int i = 0; i < longs.length; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }

    private static long[] decodeLongArray(UnitType<? extends Number> type, int elementLen, int arrayLen, byte[] buffer, int idx) {
        long[] longs = new long[arrayLen];
        if (type.unsigned) {
            Uint uint = new Uint(type.bitLength);
            for (int i = 0; i < arrayLen; ++i) {
                longs[i] = PackedDecoder.decodeUnsignedLong(uint, buffer, idx, elementLen);
                idx += elementLen;
            }
        } else {
            for (int i = 0; i < arrayLen; ++i) {
                longs[i] = PackedDecoder.decodeSignedLong(buffer, idx, elementLen);
                idx += elementLen;
            }
        }
        return longs;
    }

    private static BigInteger[] decodeBigIntegerArray(BigIntegerType elementType, int elementLen, int arrayLen, byte[] buffer, int idx) {
        Object[] bigInts = new BigInteger[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            idx += PackedDecoder.insertBigInteger(elementType, elementLen, buffer, idx, bigInts, i);
        }
        return bigInts;
    }

    private static BigDecimal[] decodeBigDecimalArray(BigDecimalType elementType, int elementLen, int arrayLen, byte[] buffer, int idx) {
        Object[] bigDecimals = new BigDecimal[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            idx += PackedDecoder.insertBigDecimal(elementType, elementLen, buffer, idx, bigDecimals, i);
        }
        return bigDecimals;
    }

    private static Object[] decodeObjectArray(int arrayLen, ABIType<?> elementType, byte[] buffer, int idx, int end) {
        Object[] objects = (Object[])Array.newInstance(elementType.clazz, arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            int len = PackedDecoder.decode(elementType, buffer, idx, end, objects, i);
            idx += len;
            end -= len;
        }
        return objects;
    }

    private static long decodeLong(UnitType<? extends Number> type, byte[] buffer, int idx, int len) {
        return type.unsigned ? PackedDecoder.decodeUnsignedLong(new Uint(type.bitLength), buffer, idx, len) : PackedDecoder.decodeSignedLong(buffer, idx, len);
    }

    private static long decodeUnsignedLong(Uint uint, byte[] buffer, int idx, int len) {
        long signed = PackedDecoder.decodeBigInteger(buffer, idx, len).longValue();
        return uint.toUnsignedLong(signed);
    }

    private static long decodeSignedLong(byte[] buffer, int idx, int len) {
        return PackedDecoder.decodeBigInteger(buffer, idx, len).longValue();
    }

    static BigInteger decodeBigInteger(byte[] buffer, int i, int len) {
        return new BigInteger(Arrays.copyOfRange(buffer, i, i + len));
    }
}

