/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.PackedDecoder;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;

public abstract class ABIType<J> {
    public static final int TYPE_CODE_BOOLEAN = 0;
    public static final int TYPE_CODE_BYTE = 1;
    public static final int TYPE_CODE_INT = 2;
    public static final int TYPE_CODE_LONG = 3;
    public static final int TYPE_CODE_BIG_INTEGER = 4;
    public static final int TYPE_CODE_BIG_DECIMAL = 5;
    public static final int TYPE_CODE_ARRAY = 6;
    public static final int TYPE_CODE_TUPLE = 7;
    public static final int TYPE_CODE_ADDRESS = 8;
    public static final ABIType<?>[] EMPTY_ARRAY = new ABIType[0];
    final String canonicalType;
    final Class<J> clazz;
    final boolean dynamic;
    private static final int LABEL_LEN = 6;
    private static final int LABEL_PADDED_LEN = 9;

    ABIType(String canonicalType, Class<J> clazz, boolean dynamic) {
        this.canonicalType = canonicalType;
        this.clazz = clazz;
        this.dynamic = dynamic;
    }

    public final String getCanonicalType() {
        return this.canonicalType;
    }

    public final Class<J> clazz() {
        return this.clazz;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    abstract Class<?> arrayClass();

    public abstract int typeCode();

    abstract int headLength();

    int dynamicByteLength(J value) {
        throw new UnsupportedOperationException();
    }

    abstract int byteLength(J var1);

    abstract int byteLengthPacked(J var1);

    public abstract int validate(J var1);

    final void validateClass(J value) {
        if (!this.clazz.isInstance(value)) {
            if (value == null) {
                throw new NullPointerException();
            }
            throw this.mismatchErr("class", value.getClass().getName(), this.clazz.getName(), ABIType.friendlyClassName(this.clazz, -1), ABIType.friendlyClassName(value.getClass(), -1));
        }
    }

    final IllegalArgumentException mismatchErr(String prefix, String a, String e, String r, String f) {
        return new IllegalArgumentException(prefix + " mismatch: " + a + " != " + e + " (" + this.canonicalType + " requires " + r + " but found " + f + ")");
    }

    public final int measureEncodedLength(J value) {
        return this.validate(value);
    }

    public final ByteBuffer encode(J value) {
        ByteBuffer dest = ByteBuffer.allocate(this.validate(value));
        this.encodeTail(value, dest);
        dest.flip();
        return dest;
    }

    public final void encode(J value, ByteBuffer dest) {
        this.validate(value);
        this.encodeTail(value, dest);
    }

    final int encodeHead(J value, ByteBuffer dest, int offset) {
        if (!this.dynamic) {
            this.encodeTail(value, dest);
            return offset;
        }
        Encoding.insertIntUnsigned(offset, dest);
        return offset + this.dynamicByteLength(value);
    }

    abstract void encodeTail(J var1, ByteBuffer var2);

    public final ByteBuffer encodePacked(J value) {
        this.validate(value);
        ByteBuffer dest = ByteBuffer.allocate(this.byteLengthPacked(value));
        this.encodePackedUnchecked(value, dest);
        return dest;
    }

    public final void encodePacked(J value, ByteBuffer dest) {
        this.validate(value);
        this.encodePackedUnchecked(value, dest);
    }

    abstract void encodePackedUnchecked(J var1, ByteBuffer var2);

    public final J decode(byte[] array) {
        return this.decode(array, 0, array.length);
    }

    J decode(byte[] buffer, int offset, int len) {
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, len);
        J decoded = this.decode(bb);
        int remaining = bb.remaining();
        if (remaining == 0) {
            return decoded;
        }
        throw new IllegalArgumentException("unconsumed bytes: " + remaining + " remaining");
    }

    public final J decode(ByteBuffer buffer) {
        return this.decode(buffer, ABIType.newUnitBuffer());
    }

    abstract J decode(ByteBuffer var1, byte[] var2);

    public final J decodePacked(byte[] buffer) {
        return (J)PackedDecoder.decode(TupleType.wrap(null, this), buffer).get(0);
    }

    public abstract J parseArgument(String var1);

    static byte[] newUnitBuffer() {
        return new byte[32];
    }

    public final int hashCode() {
        return this.canonicalType.hashCode();
    }

    public final boolean equals(Object o) {
        return o == this || o instanceof ABIType && ((ABIType)o).canonicalType.equals(this.canonicalType);
    }

    public final String toString() {
        return this.canonicalType;
    }

    public static String format(byte[] abi) {
        return ABIType.format(abi, row -> {
            String unpadded = Integer.toHexString(row * 32);
            return ABIType.pad(6 - unpadded.length(), unpadded);
        });
    }

    public static String format(byte[] abi, IntFunction<String> labeler) {
        Integers.checkIsMultiple(abi.length, 32);
        return ABIType.finishFormat(abi, 0, abi.length, labeler, new StringBuilder());
    }

    static String finishFormat(byte[] buffer, int offset, int end, IntFunction<String> labeler, StringBuilder sb) {
        int row = 0;
        while (offset < end) {
            if (offset > 0) {
                sb.append('\n');
            }
            sb.append(labeler.apply(row++)).append(Strings.encode(buffer, offset, 32, 0));
            offset += 32;
        }
        return sb.toString();
    }

    static String pad(int leftPadding, String unpadded) {
        StringBuilder sb = new StringBuilder();
        ABIType.pad(sb, leftPadding);
        sb.append(unpadded);
        ABIType.pad(sb, 9 - sb.length());
        return sb.toString();
    }

    private static void pad(StringBuilder sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
    }

    static String friendlyClassName(Class<?> clazz, int arrayLen) {
        String base;
        String className = clazz.getName();
        int split = className.lastIndexOf(91) + 1;
        boolean hasArraySuffix = split > 0;
        StringBuilder sb = new StringBuilder();
        switch (base = hasArraySuffix ? className.substring(split) : className) {
            case "B": {
                sb.append("byte");
                break;
            }
            case "S": {
                sb.append("short");
                break;
            }
            case "I": {
                sb.append("int");
                break;
            }
            case "J": {
                sb.append("long");
                break;
            }
            case "F": {
                sb.append("float");
                break;
            }
            case "D": {
                sb.append("double");
                break;
            }
            case "C": {
                sb.append("char");
                break;
            }
            case "Z": {
                sb.append("boolean");
                break;
            }
            default: {
                int lastDotIndex = base.lastIndexOf(46);
                if (lastDotIndex == -1) break;
                sb.append(base, lastDotIndex + 1, base.length() - (base.charAt(0) == 'L' ? 1 : 0));
            }
        }
        if (hasArraySuffix) {
            int i = 0;
            if (arrayLen >= 0) {
                sb.append('[').append(arrayLen).append(']');
            }
            while (true) {
                int n = ++i;
                ++i;
                if (n >= split) break;
                sb.append("[]");
            }
        }
        return sb.toString();
    }
}

