/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.SuperSerial;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.function.IntUnaryOperator;

public final class ArrayType<E extends ABIType<?>, J>
extends ABIType<J> {
    private static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    static final Class<String> STRING_CLASS = String.class;
    static final Class<String[]> STRING_ARRAY_CLASS = String[].class;
    public static final int DYNAMIC_LENGTH = -1;
    private final boolean isString;
    private final E elementType;
    private final int length;
    private final Class<?> arrayClass;
    private final int headLength;

    ArrayType(String canonicalType, Class<J> clazz, E elementType, int length, Class<?> arrayClass) {
        super(canonicalType, clazz, -1 == length || ((ABIType)elementType).dynamic);
        this.isString = STRING_CLASS == clazz;
        this.elementType = elementType;
        this.length = length;
        this.arrayClass = arrayClass;
        this.headLength = this.dynamic ? 32 : ArrayType.staticArrayHeadLength(this);
    }

    static int staticArrayHeadLength(ArrayType<?, ?> at) {
        switch (((ABIType)at.elementType).typeCode()) {
            case 1: {
                return 32;
            }
            case 6: {
                return at.length * ArrayType.staticArrayHeadLength((ArrayType)at.elementType);
            }
            case 7: {
                return at.length * TupleType.staticTupleHeadLength((TupleType)at.elementType);
            }
        }
        return at.length * 32;
    }

    public E getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isString() {
        return this.isString;
    }

    private ABIType<Object> elementTypeNonCapturing() {
        return this.elementType;
    }

    @Override
    Class<?> arrayClass() {
        if (this.arrayClass != null) {
            return this.arrayClass;
        }
        try {
            return Class.forName('[' + this.clazz.getName(), false, CLASS_LOADER);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
    }

    @Override
    public int typeCode() {
        return 6;
    }

    @Override
    int headLength() {
        return this.headLength;
    }

    @Override
    int dynamicByteLength(J value) {
        return TupleType.totalLen(this.calcElementsLen(value), this.length == -1);
    }

    @Override
    int byteLength(J value) {
        if (!this.dynamic) {
            return this.headLength;
        }
        return TupleType.totalLen(this.calcElementsLen(value), this.length == -1);
    }

    private int calcElementsLen(J value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length * 32;
            }
            case 1: {
                return Integers.roundLengthUp(this.byteCount(value), 32);
            }
            case 2: {
                return ((int[])value).length * 32;
            }
            case 3: {
                return ((long[])value).length * 32;
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * 32;
            }
            case 6: 
            case 7: {
                return this.measureByteLength((Object[])value);
            }
            case 8: {
                return ((Address[])value).length * 32;
            }
        }
        throw new AssertionError();
    }

    private int staticByteLengthPacked() {
        if (this.length == -1) {
            throw new IllegalArgumentException("array of dynamic elements");
        }
        return this.length * ((ABIType)this.elementType).byteLengthPacked(null);
    }

    @Override
    int byteLengthPacked(J value) {
        if (value == null) {
            return this.staticByteLengthPacked();
        }
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length;
            }
            case 1: {
                return this.byteCount(value);
            }
            case 2: {
                return ((int[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 3: {
                return ((long[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 4: 
            case 5: {
                return ((Number[])value).length * ((ABIType)this.elementType).byteLengthPacked(null);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.measureByteLengthPacked((Object[])value);
            }
        }
        throw new AssertionError();
    }

    private int byteCount(Object value) {
        return this.decodeIfString(value).length;
    }

    private byte[] decodeIfString(Object value) {
        return !this.isString ? (byte[])value : Strings.decode((String)value, 1);
    }

    Object encodeIfString(byte[] bytes) {
        return !this.isString ? bytes : (byte[])Strings.encode(bytes, 1);
    }

    @Override
    public int validate(J value) {
        this.validateClass(value);
        return TupleType.totalLen(this.validateElements(value), this.length == -1);
    }

    private int validateElements(J value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return this.validateBooleans((boolean[])value);
            }
            case 1: {
                return this.validateBytes(value);
            }
            case 2: {
                return this.validateInts((int[])value, (IntType)this.elementType);
            }
            case 3: {
                return this.validateLongs((long[])value, (LongType)this.elementType);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.validateObjects((Object[])value);
            }
        }
        throw new AssertionError();
    }

    private int validateBooleans(boolean[] arr) {
        return this.checkLength(arr.length, arr) * 32;
    }

    private int validateBytes(J arr) {
        return Integers.roundLengthUp(this.checkLength(this.byteCount(arr), arr), 32);
    }

    private int measureArrayElements(int n, IntUnaryOperator measurer) {
        return ((ABIType)this.elementType).dynamic ? 32 * n + TupleType.countBytes(true, n, measurer) : TupleType.countBytes(true, n, measurer);
    }

    private int validateInts(int[] arr, IntType type) {
        return this.measureArrayElements(this.checkLength(arr.length, arr), i -> type.validatePrimitive(arr[i]));
    }

    private int validateLongs(long[] arr, LongType type) {
        return this.measureArrayElements(this.checkLength(arr.length, arr), i -> type.validatePrimitive(arr[i]));
    }

    private int validateObjects(Object[] arr) {
        ABIType<Object> et = this.elementTypeNonCapturing();
        return this.measureArrayElements(this.checkLength(arr.length, arr), i -> et.validate(arr[i]));
    }

    private int measureByteLength(Object[] arr) {
        ABIType<Object> et = this.elementTypeNonCapturing();
        return this.measureArrayElements(arr.length, i -> et.byteLength(arr[i]));
    }

    private int measureByteLengthPacked(Object[] arr) {
        ABIType<Object> et = this.elementTypeNonCapturing();
        return TupleType.countBytes(true, arr.length, i -> et.byteLengthPacked(arr[i]));
    }

    private int checkLength(int valueLen, Object value) {
        if (this.length != -1 && this.length != valueLen) {
            throw this.mismatchErr("array length", ArrayType.friendlyClassName(value.getClass(), valueLen), ArrayType.friendlyClassName(this.clazz, this.length), "length " + this.length, "" + valueLen);
        }
        return valueLen;
    }

    @Override
    void encodeTail(J value, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                this.encodeBooleans((boolean[])value, dest);
                return;
            }
            case 1: {
                this.encodeBytes(this.decodeIfString(value), dest);
                return;
            }
            case 2: {
                this.encodeInts((int[])value, dest);
                return;
            }
            case 3: {
                this.encodeLongs((long[])value, dest);
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.encodeObjects((Object[])value, dest);
                return;
            }
        }
        throw new AssertionError();
    }

    private void encodeObjects(Object[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        ABIType<Object> et = this.elementTypeNonCapturing();
        TupleType.encodeObjects(this.dynamic, arr, i -> et, dest, 32 * arr.length);
    }

    private void encodeArrayLen(int len, ByteBuffer dest) {
        if (this.length == -1) {
            Encoding.insertIntUnsigned(len, dest);
        }
    }

    private void encodeBooleans(boolean[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (boolean e : arr) {
            BooleanType.encodeBoolean(e, dest);
        }
    }

    private void encodeBytes(byte[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        dest.put(arr);
        int rem = Integers.mod(arr.length, 32);
        Encoding.insert00Padding(rem != 0 ? 32 - rem : 0, dest);
    }

    private void encodeInts(int[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (int e : arr) {
            Encoding.insertInt(e, dest);
        }
    }

    private void encodeLongs(long[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (long e : arr) {
            Encoding.insertInt(e, dest);
        }
    }

    @Override
    void encodePackedUnchecked(J value, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                ArrayType.encodeBooleansPacked((boolean[])value, dest);
                return;
            }
            case 1: {
                dest.put(this.decodeIfString(value));
                return;
            }
            case 2: {
                ArrayType.encodeIntsPacked((int[])value, ((ABIType)this.elementType).byteLengthPacked(null), dest);
                return;
            }
            case 3: {
                ArrayType.encodeLongsPacked((long[])value, ((ABIType)this.elementType).byteLengthPacked(null), dest);
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ABIType<Object> et = this.elementTypeNonCapturing();
                for (Object e : (Object[])value) {
                    et.encodePackedUnchecked(e, dest);
                }
                return;
            }
        }
        throw new AssertionError();
    }

    private static void encodeBooleansPacked(boolean[] arr, ByteBuffer dest) {
        for (boolean bool : arr) {
            BooleanType.encodeBooleanPacked(bool, dest);
        }
    }

    private static void encodeIntsPacked(int[] arr, int byteLen, ByteBuffer dest) {
        for (int e : arr) {
            LongType.encodeLong(e, byteLen, dest);
        }
    }

    private static void encodeLongsPacked(long[] arr, int byteLen, ByteBuffer dest) {
        for (long e : arr) {
            LongType.encodeLong(e, byteLen, dest);
        }
    }

    @Override
    J decode(ByteBuffer bb, byte[] unitBuffer) {
        int arrayLen = this.length == -1 ? Encoding.UINT19.decode(bb, unitBuffer) : this.length;
        this.checkNoDecodePossible(bb.remaining(), arrayLen);
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return (J)ArrayType.decodeBooleans(arrayLen, bb, unitBuffer);
            }
            case 1: {
                return (J)this.decodeBytes(arrayLen, bb);
            }
            case 2: {
                return (J)ArrayType.decodeInts(arrayLen, bb, (IntType)this.elementType, unitBuffer);
            }
            case 3: {
                return (J)ArrayType.decodeLongs(arrayLen, bb, (LongType)this.elementType, unitBuffer);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return (J)this.decodeObjects(arrayLen, bb, unitBuffer);
            }
        }
        throw new AssertionError();
    }

    private void checkNoDecodePossible(int remaining, int arrayLen) {
        int minByteLen;
        int n = !this.dynamic ? this.headLength : (((ABIType)this.elementType).dynamic ? arrayLen * 32 : (minByteLen = this.elementType instanceof ByteType ? Integers.roundLengthUp(arrayLen, 32) : arrayLen * ((ABIType)this.elementType).headLength()));
        if (remaining < minByteLen) {
            throw new IllegalArgumentException("not enough bytes remaining: " + remaining + " < " + minByteLen);
        }
    }

    private static boolean[] decodeBooleans(int len, ByteBuffer bb, byte[] unitBuffer) {
        boolean[] booleans = new boolean[len];
        int valOffset = 31;
        block4: for (int i = 0; i < len; ++i) {
            bb.get(unitBuffer);
            for (int j = 0; j < 31; ++j) {
                if (unitBuffer[j] == 0) continue;
                throw new IllegalArgumentException("illegal boolean value @ " + (bb.position() - 32));
            }
            switch (unitBuffer[31]) {
                case 1: {
                    booleans[i] = true;
                }
                case 0: {
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("illegal boolean value @ " + (bb.position() - 32));
                }
            }
        }
        return booleans;
    }

    private Object decodeBytes(int len, ByteBuffer bb) {
        byte[] data = new byte[len];
        bb.get(data);
        int mod = Integers.mod(len, 32);
        if (mod != 0) {
            byte[] padding = new byte[32 - mod];
            bb.get(padding);
            for (byte b : padding) {
                if (b == 0) continue;
                throw new IllegalArgumentException("malformed array: non-zero padding byte");
            }
        }
        return this.encodeIfString(data);
    }

    private static int[] decodeInts(int len, ByteBuffer bb, IntType intType, byte[] unitBuffer) {
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            ints[i] = intType.decode(bb, unitBuffer);
        }
        return ints;
    }

    private static long[] decodeLongs(int len, ByteBuffer bb, LongType longType, byte[] unitBuffer) {
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = longType.decode(bb, unitBuffer);
        }
        return longs;
    }

    private Object[] decodeObjects(int len, ByteBuffer bb, byte[] unitBuffer) {
        Object[] elements = (Object[])Array.newInstance(((ABIType)this.elementType).clazz, len);
        TupleType.decodeObjects(this.dynamic, bb, unitBuffer, i -> this.elementType, elements);
        return elements;
    }

    @Override
    public J parseArgument(String s) {
        return (J)SuperSerial.deserializeArray(this, s, false);
    }

    public static <T extends ABIType<?>> T baseType(ABIType<?> type) {
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getElementType();
        }
        return (T)type;
    }
}

