/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.IntType;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class Encoding {
    static final int OFFSET_LENGTH_BYTES = 32;
    static final IntType UINT19 = new IntType("uint19", 19, true);
    static final IntType UINT31 = new IntType("uint31", 31, true);
    static final byte ZERO_BYTE = 0;
    static final byte ONE_BYTE = 1;
    private static final byte[] CACHED_ZERO_PADDING = new byte[32];
    private static final byte[] CACHED_NEG1_PADDING = new byte[32];

    private Encoding() {
    }

    static void insertIntUnsigned(long val, ByteBuffer dest) {
        Encoding.insert00Padding(24, dest);
        dest.putLong(val);
    }

    static void insertInt(long val, ByteBuffer dest) {
        Encoding.insertPadding(24, val < 0L, dest);
        dest.putLong(val);
    }

    static void insertInt(BigInteger signed, int paddedLen, ByteBuffer dest) {
        byte[] arr = signed.toByteArray();
        if (arr.length <= paddedLen) {
            Encoding.insertPadding(paddedLen - arr.length, signed.signum() < 0, dest);
            dest.put(arr, 0, arr.length);
        } else {
            dest.put(arr, 1, paddedLen);
        }
    }

    private static void insertPadding(int n, boolean negativeOnes, ByteBuffer dest) {
        if (negativeOnes) {
            Encoding.insertFFPadding(n, dest);
        } else {
            Encoding.insert00Padding(n, dest);
        }
    }

    static void insert00Padding(int n, ByteBuffer dest) {
        dest.put(CACHED_ZERO_PADDING, 0, n);
    }

    static void insertFFPadding(int n, ByteBuffer dest) {
        dest.put(CACHED_NEG1_PADDING, 0, n);
    }

    static {
        Arrays.fill(CACHED_NEG1_PADDING, (byte)-1);
    }
}

