/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;

public final class KVP
implements Comparable<KVP> {
    public static final KVP[] EMPTY_ARRAY = new KVP[0];
    public static final String ID = "id";
    public static final String SECP256K1 = "secp256k1";
    public static final String IP = "ip";
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    public static final String IP6 = "ip6";
    public static final String TCP6 = "tcp6";
    public static final String UDP6 = "udp6";
    final byte[] rlp;
    final RLPString key;

    public KVP(String keyUtf8, String val, int valEncoding) {
        this(keyUtf8, Strings.decode(val, valEncoding));
    }

    public KVP(String keyUtf8, byte[] rawVal) {
        this(Strings.decode(keyUtf8, 1), rawVal);
    }

    public KVP(byte[] key, byte[] value) {
        this.rlp = RLPEncoder.sequence(key, value);
        this.key = RLPDecoder.RLP_STRICT.wrapString(this.rlp);
    }

    public KVP(RLPString key, RLPString value) {
        int keyLen = key.encodingLength();
        this.rlp = new byte[keyLen + value.encodingLength()];
        key.copy(this.rlp, 0);
        value.copy(this.rlp, keyLen);
        this.key = RLPDecoder.RLP_STRICT.wrapString(this.rlp);
    }

    public KVP withValue(String val, int valEncoding) {
        return this.withValue(Strings.decode(val, valEncoding));
    }

    public KVP withValue(byte[] value) {
        return new KVP(this.key, RLPDecoder.RLP_STRICT.wrapString(RLPEncoder.string(value)));
    }

    public RLPString key() {
        return this.key;
    }

    public RLPString value() {
        return RLPDecoder.RLP_STRICT.wrapString(this.rlp, this.key.endIndex);
    }

    void export(ByteBuffer bb) {
        bb.put(this.rlp);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof KVP && this.key.equals(((KVP)o).key);
    }

    public String toString() {
        return this.key.asString(1) + " --> " + this.value().asString(0);
    }

    @Override
    public int compareTo(KVP other) {
        int result = this.key.compareTo(other.key);
        if (result == 0) {
            throw KVP.duplicateKeyErr(this.key);
        }
        return result;
    }

    static IllegalArgumentException duplicateKeyErr(RLPString key) {
        return new IllegalArgumentException("duplicate key: " + key.asString(1));
    }
}

