/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPSequenceIterator;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.rlp.ShortInputException;
import com.esaulpaugh.headlong.util.Integers;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RLPDecoder {
    public static final RLPDecoder RLP_STRICT = new RLPDecoder(false);
    public static final RLPDecoder RLP_LENIENT = new RLPDecoder(true);
    public final boolean lenient;

    private RLPDecoder(boolean lenient) {
        this.lenient = lenient;
    }

    public Iterator<RLPItem> sequenceIterator(byte[] buffer) {
        return this.sequenceIterator(buffer, 0);
    }

    public Iterator<RLPItem> sequenceIterator(byte[] buffer, int index) {
        return new RLPSequenceIterator(this, buffer, index);
    }

    public Iterator<RLPItem> sequenceIterator(InputStream is) {
        return new RLPSequenceIterator.StreamRLPSequenceIterator(is, this);
    }

    public Stream<RLPItem> stream(byte[] bytes) {
        return RLPDecoder.stream(this.sequenceIterator(bytes));
    }

    public Stream<RLPItem> stream(byte[] buffer, int index) {
        return RLPDecoder.stream(this.sequenceIterator(buffer, index));
    }

    public Stream<RLPItem> stream(InputStream is) {
        return RLPDecoder.stream(this.sequenceIterator(is));
    }

    private static Stream<RLPItem> stream(Iterator<RLPItem> iter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 16), false);
    }

    public Iterator<RLPItem> listIterator(byte[] buffer) {
        return this.listIterator(buffer, 0);
    }

    public Iterator<RLPItem> listIterator(byte[] buffer, int index) {
        return this.wrapList(buffer, index).iterator(this);
    }

    public <T extends RLPItem> T wrapBits(long bits) {
        return this.wrap(RLPEncoder.bitsToBytes(bits), 0);
    }

    public RLPString wrapString(byte[] buffer) {
        return this.wrapString(buffer, 0);
    }

    public RLPList wrapList(byte[] buffer) {
        return this.wrapList(buffer, 0);
    }

    public RLPItem wrapItem(byte[] buffer) {
        return this.wrapItem(buffer, 0);
    }

    public RLPString wrapString(byte[] buffer, int index) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 0: {
                return RLPDecoder.newSingleByte(buffer, index, buffer.length);
            }
            case 1: {
                return RLPDecoder.newStringShort(buffer, index, lead, buffer.length, this.lenient);
            }
            case 2: {
                return (RLPString)RLPDecoder.newLongItem(lead, type, buffer, index, buffer.length, this.lenient);
            }
        }
        throw new IllegalArgumentException("item is not a string");
    }

    public RLPList wrapList(byte[] buffer, int index) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 3: {
                return RLPDecoder.newListShort(buffer, index, lead, buffer.length);
            }
            case 4: {
                return (RLPList)RLPDecoder.newLongItem(lead, type, buffer, index, buffer.length, this.lenient);
            }
        }
        throw new IllegalArgumentException("item is not a list");
    }

    public RLPItem wrapItem(byte[] buffer, int index) {
        return this.wrap(buffer, index);
    }

    public <T extends RLPItem> T wrap(byte[] buffer) {
        return this.wrap(buffer, 0);
    }

    public <T extends RLPItem> T wrap(byte[] buffer, int index) {
        return this.wrap(buffer, index, buffer.length);
    }

    <T extends RLPItem> T wrap(byte[] buffer, int index, int containerEnd) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 0: {
                return (T)RLPDecoder.newSingleByte(buffer, index, containerEnd);
            }
            case 1: {
                return (T)RLPDecoder.newStringShort(buffer, index, lead, containerEnd, this.lenient);
            }
            case 3: {
                return (T)RLPDecoder.newListShort(buffer, index, lead, containerEnd);
            }
            case 2: 
            case 4: {
                return RLPDecoder.newLongItem(lead, type, buffer, index, containerEnd, this.lenient);
            }
        }
        throw new AssertionError();
    }

    private static RLPString newSingleByte(byte[] buffer, int index, int containerEnd) {
        int endIndex = RLPDecoder.requireInBounds((long)index + 1L, containerEnd, buffer, index);
        return new RLPString(buffer, index, index, 1, endIndex);
    }

    private static RLPString newStringShort(byte[] buffer, int index, byte lead, int containerEnd, boolean lenient) {
        int dataIndex = index + 1;
        int dataLength = lead - -128;
        int endIndex = RLPDecoder.requireInBounds((long)dataIndex + (long)dataLength, containerEnd, buffer, index);
        if (!lenient && dataLength == 1 && DataType.isSingleByte(buffer[dataIndex])) {
            throw new IllegalArgumentException("invalid rlp for single byte @ " + index);
        }
        return new RLPString(buffer, index, dataIndex, dataLength, endIndex);
    }

    private static RLPList newListShort(byte[] buffer, int index, byte lead, int containerEnd) {
        int dataIndex = index + 1;
        int dataLength = lead - -64;
        int endIndex = RLPDecoder.requireInBounds((long)dataIndex + (long)dataLength, containerEnd, buffer, index);
        return new RLPList(buffer, index, dataIndex, dataLength, endIndex);
    }

    private static <T extends RLPItem> T newLongItem(byte lead, DataType type, byte[] buffer, int index, int containerEnd, boolean lenient) {
        int diff = lead - type.offset;
        int lengthIndex = index + 1;
        int dataIndex = RLPDecoder.requireInBounds((long)lengthIndex + (long)diff, containerEnd, buffer, index);
        long dataLength = Integers.getLong(buffer, lengthIndex, diff, lenient);
        if (dataLength < 56L) {
            throw new IllegalArgumentException("long element data length must be 56 or greater; found: " + dataLength + " for element @ " + index);
        }
        int dataLen = RLPDecoder.requireInBounds(dataLength, containerEnd, buffer, index);
        int endIndex = RLPDecoder.requireInBounds((long)dataIndex + dataLength, containerEnd, buffer, index);
        return (T)(type.isString ? new RLPString(buffer, index, dataIndex, dataLen, endIndex) : new RLPList(buffer, index, dataIndex, dataLen, endIndex));
    }

    private static int requireInBounds(long val, int containerEnd, byte[] buffer, int index) {
        if (val > (long)containerEnd) {
            String msg = "element @ index " + index + " exceeds its container: " + val + " > " + containerEnd;
            throw buffer.length == containerEnd ? new ShortInputException(msg) : new IllegalArgumentException(msg);
        }
        return (int)val;
    }
}

