/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ContractError;
import com.esaulpaugh.headlong.abi.Event;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.util.JsonUtils;
import com.google.gson.JsonObject;

public interface ABIObject {
    public TypeEnum getType();

    public String getName();

    public TupleType getInputs();

    public String getCanonicalSignature();

    default public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, pretty);
    }

    default public boolean isFunction() {
        return false;
    }

    default public boolean isEvent() {
        return false;
    }

    default public boolean isContractError() {
        return false;
    }

    default public Function asFunction() {
        return (Function)this;
    }

    default public Event asEvent() {
        return (Event)this;
    }

    default public ContractError asContractError() {
        return (ContractError)this;
    }

    public static <T extends ABIObject> T fromJson(String json) {
        return ABIObject.fromJsonObject(JsonUtils.parseObject(json));
    }

    public static <T extends ABIObject> T fromJsonObject(JsonObject object) {
        return ABIJSON.parseABIObject(object);
    }
}

